/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.reminder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;

public class ReminderFunctions
extends AbstractObjectFunctions {
    private final ReminderRules rules;
    private final CustomerRules customerRules;
    private final IArchetypeService service;

    public ReminderFunctions(IArchetypeService archetypeService, ReminderRules rules, CustomerRules customerRules) {
        super("reminder");
        this.setObject((Object)this);
        this.service = archetypeService;
        this.rules = rules;
        this.customerRules = customerRules;
    }

    public Iterable<Act> getReminders(Act act, int dueInterval, String dueUnits) {
        return this.getReminders(act, dueInterval, dueUnits, false);
    }

    public Iterable<Act> getReminders(Act act, int dueInterval, String dueUnits, boolean includeOverdue) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Iterable<Act> result = customer != null ? this.getReminders(customer, dueInterval, dueUnits, includeOverdue) : Collections.emptyList();
        return result;
    }

    public Iterable<Act> getReminders(Party customer, int dueInterval, String dueUnits) {
        return this.getReminders(customer, dueInterval, dueUnits, false);
    }

    public Iterable<Act> getReminders(Party customer, int dueInterval, String dueUnits, boolean includeOverdue) {
        List<Act> result;
        if (customer != null) {
            result = new ArrayList();
            DateUnits units = DateUnits.valueOf(dueUnits);
            List<Act> reminders = this.customerRules.getReminders(customer, dueInterval, units, includeOverdue);
            for (Act reminder : reminders) {
                IMObjectBean patientBean;
                IMObjectBean bean = this.service.getBean((IMObject)reminder);
                Party patient = (Party)bean.getTarget("patient", Party.class);
                if (patient == null || !patient.isActive() || (patientBean = this.service.getBean((IMObject)patient)).getBoolean("deceased")) continue;
                result.add(reminder);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public Act getDocumentFormReminder(DocumentAct form) {
        return this.rules.getDocumentFormReminder(form);
    }

    public Iterable<Act> getPatientReminders(Party patient, Date date) {
        if (patient != null && date != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.getPatientReminders(patient, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> getPatientReminders(Party patient, Date from, Date to) {
        if (patient != null && from != null && to != null) {
            return this.rules.getReminders(patient, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> getRemindersByProductType(Party patient, String productType, Date date) {
        if (patient != null && date != null && productType != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.getRemindersByProductType(patient, productType, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> getRemindersByProductType(Party patient, String productType, Date from, Date to) {
        if (patient != null && from != null && to != null && productType != null) {
            return this.rules.getReminders(patient, productType, from, to);
        }
        return Collections.emptyList();
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("getReminders".equals(name) && this.hasPatient(parameters)) {
            name = (parameters.length == 3 || parameters.length == 4) && parameters[1] instanceof String ? "getRemindersByProductType" : "getPatientReminders";
        }
        return super.getFunction(namespace, name, parameters);
    }

    private boolean hasPatient(Object[] parameters) {
        boolean result = false;
        if (parameters != null && parameters.length > 0) {
            List pointers;
            Object parameter = parameters[0];
            if (this.isPatient(parameter)) {
                result = true;
            } else if (parameter instanceof NodeSet && (pointers = ((NodeSet)parameter).getPointers()) != null && pointers.size() == 1 && this.isPatient(pointers.get(0))) {
                result = true;
            }
        }
        return result;
    }

    private boolean isPatient(Object parameter) {
        if (parameter instanceof Pointer) {
            parameter = ((Pointer)parameter).getValue();
        }
        return parameter instanceof IMObject && TypeHelper.isA((IMObject)((IMObject)parameter), (String)"party.patientpet");
    }
}

