/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.lang3.ObjectUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertySetResolver;
import org.openvpms.component.business.service.archetype.helper.sort.IMObjectSorter;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;

public class ListFunctions
extends AbstractObjectFunctions {
    private final IArchetypeService service;
    private final LookupService lookups;
    private final IMObjectSorter sorter;
    private static final String SEPARATOR = ", ";

    public ListFunctions(IArchetypeService service, LookupService lookups) {
        super("list");
        this.setObject((Object)this);
        this.service = service;
        this.lookups = lookups;
        this.sorter = new IMObjectSorter(service, lookups);
    }

    public Object first(Iterable<Object> objects) {
        if (objects != null) {
            Iterator<Object> iterator = objects.iterator();
            return iterator.hasNext() ? iterator.next() : null;
        }
        return null;
    }

    public Object first(Object object, String name) {
        List<Object> objects = this.values(object, name);
        return !objects.isEmpty() ? objects.get(0) : null;
    }

    public <T extends IMObject> List<T> sort(Iterable<T> objects, String node) {
        return this.sorter.sort(this.asList(objects), node, true);
    }

    public String names(Object objects) {
        return this.names(objects, SEPARATOR);
    }

    public String names(Object objects, String separator) {
        return this.join(objects, "name", separator);
    }

    public String names(Object objects, String separator, String lastSeparator) {
        return this.names(objects, separator, lastSeparator, null, null);
    }

    public String names(Object objects, String separator, String lastSeparator, String singular, String plural) {
        return this.join(objects, "name", separator, lastSeparator, singular, plural);
    }

    public String sortNamesOf(ExpressionContext context, String name) {
        return this.sortNamesOf(context.getContextNodePointer().getValue(), name);
    }

    public String sortNamesOf(Object objects, String name) {
        return this.sortNamesOf(objects, name, SEPARATOR);
    }

    public String sortNamesOf(Object objects, String name, String separator) {
        return this.sortNamesOf(objects, name, separator, separator);
    }

    public String sortNamesOf(Object objects, String name, String separator, String lastSeparator) {
        return this.sortNamesOf(objects, name, separator, lastSeparator, null, null);
    }

    public String sortNamesOf(Object objects, String name, String separator, String lastSeparator, String singular, String plural) {
        List<Object> values = this.values(objects, name);
        return this.sortNames(values, separator, lastSeparator, singular, plural);
    }

    public String sortNames(Object objects) {
        return this.sortNames(objects, SEPARATOR);
    }

    public String sortNames(Object objects, String separator) {
        return this.sortNames(objects, separator, separator);
    }

    public String sortNames(Object objects, String separator, String lastSeparator) {
        return this.sortNames(objects, separator, lastSeparator, null, null);
    }

    public String sortNames(Object objects, String separator, String lastSeparator, String singular, String plural) {
        return this.join(objects, "name", separator, lastSeparator, singular, plural, (o1, o2) -> {
            String v1 = o1 != null ? o1.toString() : null;
            String v2 = o2 != null ? o2.toString() : null;
            return ObjectUtils.compare((Comparable)((Object)v1), (Comparable)((Object)v2));
        });
    }

    public String join(Object objects, String node) {
        return this.join(objects, node, SEPARATOR);
    }

    public String join(Object objects, String name, String separator) {
        return this.join(objects, name, separator, separator);
    }

    public String join(Object objects, String name, String separator, String lastSeparator) {
        return this.join(objects, name, separator, lastSeparator, null, null);
    }

    public String join(Object objects, String name, String separator, String lastSeparator, String singular, String plural) {
        return this.join(objects, name, separator, lastSeparator, singular, plural, null);
    }

    public Set<Object> set(ExpressionContext context, String name) {
        Pointer pointer = context.getContextNodePointer();
        Object value = pointer.getValue();
        return this.set(value, name);
    }

    public Set<Object> set(Object object, String name) {
        return this.collect(object, name, new LinkedHashSet());
    }

    public List<Object> values(ExpressionContext context, String name) {
        Pointer pointer = context.getContextNodePointer();
        Object value = pointer.getValue();
        return this.values(value, name);
    }

    public List<Object> values(Object object, String name) {
        return this.collect(object, name, new ArrayList());
    }

    public List<Object> distinct(ExpressionContext context, String node) {
        return new ArrayList<Object>(this.set(context, node));
    }

    public List<Object> distinct(Object object, String node) {
        return new ArrayList<Object>(this.set(object, node));
    }

    protected String join(Object objects, String name, String separator, String lastSeparator, String singular, String plural, Comparator<Object> comparator) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        this.collect(objects, name, values);
        int size = values.size();
        if (comparator != null && size > 1) {
            values.sort(comparator);
        }
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                if (i == size - 1) {
                    builder.append(lastSeparator);
                } else {
                    builder.append(separator);
                }
            }
            builder.append(values.get(i));
        }
        if (size == 1 && singular != null) {
            builder.append(singular);
        } else if (size > 1 && plural != null) {
            builder.append(plural);
        }
        return builder.toString();
    }

    protected <T extends IMObject> List<T> asList(Iterable<T> objects) {
        ArrayList list;
        if (objects instanceof Collection) {
            list = new ArrayList((Collection)objects);
        } else {
            list = new ArrayList();
            CollectionUtils.addAll(list, objects);
        }
        return list;
    }

    protected <T extends Collection<Object>> T collect(Object object, String name, T result) {
        if (object instanceof IMObject || object instanceof PropertySet) {
            this.getValues(object, name, result);
        } else if (object instanceof Iterable) {
            for (Object element : (Iterable)object) {
                this.getValues(element, name, result);
            }
        }
        return result;
    }

    protected <T extends Collection<Object>> T getValues(Object object, String name, T result) {
        List values;
        PropertyResolver resolver = this.createResolver(object);
        if (resolver != null && (values = resolver.getObjects(name)) != null) {
            result.addAll(values);
        }
        return result;
    }

    private PropertyResolver createResolver(Object object) {
        NodeResolver resolver = null;
        if (object instanceof IMObject) {
            resolver = new NodeResolver((IMObject)object, (ArchetypeService)this.service, this.lookups);
        } else if (object instanceof ObjectSet) {
            resolver = new PropertySetResolver((PropertySet)((ObjectSet)object), (ArchetypeService)this.service, this.lookups);
        }
        return resolver;
    }
}

