/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.laboratory;

import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public class InvestigationFunctions
extends AbstractObjectFunctions {
    private final ArchetypeService service;

    public InvestigationFunctions(ArchetypeService service) {
        super("investigation");
        this.service = service;
        this.setObject((Object)this);
    }

    public String accountId(Entity investigationType, Party location) {
        return investigationType != null && location != null ? this.getAccountId((IMObject)investigationType, location.getObjectReference()) : null;
    }

    public String accountId(ExpressionContext context) {
        return this.accountId(context.getContextNodePointer().getValue());
    }

    public String accountId(Object object) {
        String result = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Act && ((Act)object).isA("act.patientInvestigation")) {
            IMObjectBean bean = this.service.getBean((IMObject)((Act)object));
            IMObject investigationType = bean.getTarget("investigationType");
            Reference location = bean.getTargetRef("location");
            if (investigationType != null && location != null) {
                result = this.getAccountId(investigationType, location);
            }
        }
        return result;
    }

    public String accountIdForInvestigationType(Object investigationType, Object location) {
        investigationType = FunctionHelper.unwrap((Object)investigationType);
        location = FunctionHelper.unwrap((Object)location);
        if (investigationType instanceof IMObject && ((IMObject)investigationType).isA("entity.investigationType") && location instanceof Party && ((Party)location).isA("party.organisationLocation")) {
            return this.getAccountId((IMObject)investigationType, ((Party)location).getObjectReference());
        }
        return null;
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("accountId".equals(name) && parameters != null && parameters.length >= 2) {
            name = "accountIdForInvestigationType";
        }
        return super.getFunction(namespace, name, parameters);
    }

    private String getAccountId(IMObject investigationType, Reference location) {
        String result = null;
        IMObjectBean typeBean = this.service.getBean(investigationType);
        Relationship relationship = (Relationship)typeBean.getValue("locations", Relationship.class, Predicates.targetEquals((Reference)location));
        if (relationship != null) {
            IMObjectBean relationshipBean = this.service.getBean((IMObject)relationship);
            result = relationshipBean.getString("accountId");
        }
        return result;
    }
}

