/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.factory;

import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.text.WordUtils;
import org.openvpms.archetype.function.contact.AddressFunctions;
import org.openvpms.archetype.function.contact.EmailFunctions;
import org.openvpms.archetype.function.contact.PhoneFunctions;
import org.openvpms.archetype.function.customer.CustomerFunctions;
import org.openvpms.archetype.function.date.DateFunctions;
import org.openvpms.archetype.function.document.DocumentFunctions;
import org.openvpms.archetype.function.eftpos.EFTPOSFunctions;
import org.openvpms.archetype.function.expression.ExpressionFunctions;
import org.openvpms.archetype.function.history.HistoryFunctions;
import org.openvpms.archetype.function.insurance.InsuranceFunctions;
import org.openvpms.archetype.function.laboratory.InvestigationFunctions;
import org.openvpms.archetype.function.letterhead.LetterheadFunctions;
import org.openvpms.archetype.function.list.ListFunctions;
import org.openvpms.archetype.function.lookup.LookupFunctions;
import org.openvpms.archetype.function.math.MathFunctions;
import org.openvpms.archetype.function.party.PartyFunctions;
import org.openvpms.archetype.function.patient.PatientFunctions;
import org.openvpms.archetype.function.product.ProductFunctions;
import org.openvpms.archetype.function.reminder.ReminderFunctions;
import org.openvpms.archetype.function.supplier.SupplierFunctions;
import org.openvpms.archetype.function.user.CachingUserFunctions;
import org.openvpms.archetype.function.user.UserFunctions;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.FunctionsFactory;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class ArchetypeFunctionsFactory
implements FunctionsFactory {
    public Functions create() {
        IArchetypeService service = this.getArchetypeService();
        return this.create(service, false);
    }

    public FunctionLibrary create(IArchetypeService service, boolean cache) {
        LookupService lookups = this.getLookupService();
        PatientAgeFormatter ageFormatter = this.getPatientAgeFormatter();
        AddressFormatter addressFormatter = this.getAddressFormatter();
        PracticeService practiceService = this.getPracticeService();
        PracticeRules rules = new PracticeRules((ArchetypeService)service, this.getCurrencies());
        PatientRules patientRules = new PatientRules(rules, practiceService, service, lookups, ageFormatter);
        CustomerRules customerRules = new CustomerRules(service, lookups, addressFormatter);
        ReminderRules reminderRules = new ReminderRules(service, patientRules);
        SupplierRules supplierRules = new SupplierRules(service);
        AppointmentRules appointmentRules = new AppointmentRules(service);
        MedicalRecordRules recordRules = new MedicalRecordRules(service);
        UserRules userRules = new UserRules(service);
        ImageService imageService = this.getImageService();
        LogoService logoService = this.getLogoService();
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new CustomerFunctions((ArchetypeService)service));
        library.addFunctions(this.create("date", new DateFunctions()));
        library.addFunctions((Functions)new ExpressionFunctions("expr"));
        library.addFunctions((Functions)new HistoryFunctions(service));
        library.addFunctions((Functions)new ListFunctions(service, lookups));
        library.addFunctions(this.create("lookup", LookupFunctions.class));
        library.addFunctions(this.create("math", new MathFunctions()));
        library.addFunctions(this.create("openvpms", new ArchetypeServiceFunctions(service, lookups)));
        library.addFunctions(this.create("document", new DocumentFunctions(service, lookups)));
        library.addFunctions(this.create("party", new PartyFunctions(service, lookups, patientRules, addressFormatter)));
        library.addFunctions(this.create("patient", (Object)new PatientFunctions(patientRules, supplierRules, appointmentRules, recordRules, service)));
        library.addFunctions((Functions)new AddressFunctions(customerRules, (ArchetypeService)service));
        library.addFunctions((Functions)new EmailFunctions(customerRules, (ArchetypeService)service));
        library.addFunctions((Functions)new PhoneFunctions(customerRules, (ArchetypeService)service));
        library.addFunctions((Functions)new ProductFunctions(new ProductPriceRules((ArchetypeService)service), practiceService, service));
        library.addFunctions((Functions)new LetterheadFunctions(logoService, (ArchetypeService)service));
        library.addFunctions(this.create("supplier", new SupplierFunctions(supplierRules)));
        library.addFunctions((Functions)new ReminderFunctions(service, reminderRules, customerRules));
        if (cache) {
            library.addFunctions((Functions)new CachingUserFunctions(userRules, (ArchetypeService)service, practiceService, lookups, imageService, (Functions)library, 1024));
        } else {
            library.addFunctions((Functions)new UserFunctions(userRules, (ArchetypeService)service, practiceService, lookups, imageService, (Functions)library));
        }
        InsuranceRules insuranceRules = new InsuranceRules(service, this.getTransactionManager());
        library.addFunctions(this.create("insurance", new InsuranceFunctions(insuranceRules, patientRules, service)));
        library.addFunctions((Functions)new InvestigationFunctions((ArchetypeService)service));
        library.addFunctions(this.create("eftpos", new EFTPOSFunctions((ArchetypeService)service)));
        library.addFunctions(this.create("word", WordUtils.class));
        return library;
    }

    protected abstract IArchetypeService getArchetypeService();

    protected abstract LookupService getLookupService();

    protected abstract PracticeService getPracticeService();

    protected abstract Currencies getCurrencies();

    protected abstract AddressFormatter getAddressFormatter();

    protected abstract PatientAgeFormatter getPatientAgeFormatter();

    protected abstract ImageService getImageService();

    protected abstract LogoService getLogoService();

    protected abstract PlatformTransactionManager getTransactionManager();

    protected Functions create(String namespace, Object object) {
        return new ObjectFunctions(object, namespace);
    }

    protected Functions create(String namespace, Class<?> functionClass) {
        return new ClassFunctions(functionClass, namespace);
    }
}

