/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.component.processor;

import org.openvpms.archetype.component.processor.BatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchProcessor
implements BatchProcessor {
    private BatchProcessorListener listener;
    private int processed;
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchProcessor.class);

    @Override
    public void setListener(BatchProcessorListener listener) {
        this.listener = listener;
    }

    @Override
    public int getProcessed() {
        return this.processed;
    }

    protected void setProcessed(int processed) {
        this.processed = processed;
    }

    protected void incProcessed(int count) {
        this.processed += count;
    }

    protected void notifyCompleted() {
        if (this.listener != null) {
            this.listener.completed();
        }
    }

    protected void notifyError(Throwable exception) {
        if (this.listener != null) {
            this.listener.error(exception);
        } else {
            log.error(exception.getMessage(), exception);
        }
    }
}

