/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.tools;

import java.io.File;
import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TestTaskGenerator {
    public static void main(String[] args) {
        String contextPath = "applicationContext.xml";
        if (!new File(contextPath).exists()) {
            new ClassPathXmlApplicationContext(contextPath);
        } else {
            new FileSystemXmlApplicationContext(contextPath);
        }
        Party[] workLists = new Party[10];
        for (int i = 0; i < workLists.length; ++i) {
            Entity taskType = ScheduleTestHelper.createTaskType("XTaskType-" + (i + 1), true);
            Party workList = ScheduleTestHelper.createWorkList(100, taskType);
            workList.setName("XWorkList-" + (i + 1));
            TestHelper.save((IMObject)workList);
            workLists[i] = workList;
        }
        ScheduleTestHelper.createWorkListView((Entity[])workLists);
        Date startTime = DateRules.getDate((Date)DateRules.getTomorrow());
        User clinician = TestHelper.createClinician();
        for (int i = 0; i < 100; ++i) {
            Party customer = TestHelper.createCustomer("", "ZCustomer " + (i + 1), true);
            Party patient = TestHelper.createPatient(customer);
            patient.setName("ZPatient " + (i + 1));
            for (Party workList : workLists) {
                Act task = ScheduleTestHelper.createTask(startTime, null, (Entity)workList, customer, patient, clinician);
                TestHelper.save((IMObject)task);
            }
        }
    }
}

