/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier.order;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.supplier.TestSupplierActItemBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestOrderItemBuilder
extends TestSupplierActItemBuilder<TestOrderBuilder, TestOrderItemBuilder> {
    private ValueStrategy receivedQuantity = ValueStrategy.unset();
    private ValueStrategy cancelledQuantity = ValueStrategy.unset();

    public TestOrderItemBuilder(TestOrderBuilder parent, ArchetypeService service) {
        super("act.supplierOrderItem", parent, service);
    }

    public TestOrderItemBuilder(FinancialAct object, TestOrderBuilder parent, ArchetypeService service) {
        super(object, parent, service);
    }

    public TestOrderItemBuilder receivedQuantity(int receivedQuantity) {
        return this.receivedQuantity(BigDecimal.valueOf(receivedQuantity));
    }

    public TestOrderItemBuilder receivedQuantity(BigDecimal receivedQuantity) {
        this.receivedQuantity = ValueStrategy.value(receivedQuantity);
        return this;
    }

    public TestOrderItemBuilder cancelledQuantity(int cancelledQuantity) {
        return this.cancelledQuantity(BigDecimal.valueOf(cancelledQuantity));
    }

    public TestOrderItemBuilder cancelledQuantity(BigDecimal cancelledQuantity) {
        this.cancelledQuantity = ValueStrategy.value(cancelledQuantity);
        return this;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.receivedQuantity.setValue(bean, "receivedQuantity");
        this.cancelledQuantity.setValue(bean, "cancelledQuantity");
        this.getService().deriveValues((IMObject)object);
    }
}

