/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestVetPracticeBuilder
extends AbstractTestPartyBuilder<Party, TestVetPracticeBuilder> {
    private final Map<Party, Date> vets = new LinkedHashMap<Party, Date>();

    public TestVetPracticeBuilder(ArchetypeService service) {
        super("party.supplierVeterinaryPractice", Party.class, service);
        this.name(ValueStrategy.random("zvetpractice"));
    }

    public TestVetPracticeBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestVetPracticeBuilder addVet(Party vet, Date start) {
        this.vets.put(vet, start);
        return this;
    }

    public TestVetPracticeBuilder addVets(Party ... vets) {
        for (Party vet : vets) {
            this.vets.put(vet, new Date());
        }
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (Map.Entry<Party, Date> entry : this.vets.entrySet()) {
            Party vet = entry.getKey();
            PeriodRelationship relationship = (PeriodRelationship)bean.addTarget("veterinarians", (IMObject)vet, "practices");
            relationship.setActiveStartTime(entry.getValue());
            toSave.add((IMObject)vet);
        }
    }
}

