/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import org.openvpms.archetype.test.builder.supplier.TestManufacturerBuilder;
import org.openvpms.archetype.test.builder.supplier.TestSupplierOrganisationBuilder;
import org.openvpms.archetype.test.builder.supplier.TestVetBuilder;
import org.openvpms.archetype.test.builder.supplier.TestVetPracticeBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryItemBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSupplierFactory {
    private final ArchetypeService service;

    public TestSupplierFactory(ArchetypeService service) {
        this.service = service;
    }

    public Party createSupplier() {
        return (Party)this.newSupplier().build();
    }

    public TestSupplierOrganisationBuilder newSupplier() {
        return new TestSupplierOrganisationBuilder(this.service);
    }

    public TestSupplierOrganisationBuilder updateSupplier(Party supplier) {
        return new TestSupplierOrganisationBuilder(supplier, this.service);
    }

    public Party createManufacturer() {
        return (Party)this.newManufacturer().build();
    }

    public TestManufacturerBuilder newManufacturer() {
        return new TestManufacturerBuilder(this.service);
    }

    public Party createVet() {
        return (Party)this.newVet().build();
    }

    public TestVetBuilder newVet() {
        return new TestVetBuilder(this.service);
    }

    public Party createVetPractice() {
        return (Party)this.newVetPractice().build();
    }

    public TestVetPracticeBuilder newVetPractice() {
        return new TestVetPracticeBuilder(this.service);
    }

    public TestVetPracticeBuilder updateVetPractice(Party practice) {
        return new TestVetPracticeBuilder(practice, this.service);
    }

    public TestOrderBuilder newOrder() {
        return new TestOrderBuilder(this.service);
    }

    public TestOrderItemBuilder newOrderItem() {
        return new TestOrderItemBuilder(null, this.service);
    }

    public TestOrderItemBuilder updateOrderItem(FinancialAct orderItem) {
        return new TestOrderItemBuilder(orderItem, null, this.service);
    }

    public TestDeliveryBuilder newDelivery() {
        return new TestDeliveryBuilder(this.service);
    }

    public TestDeliveryItemBuilder newDeliveryItem() {
        return new TestDeliveryItemBuilder(null, this.service);
    }

    public TestReturnBuilder newReturn() {
        return new TestReturnBuilder(this.service);
    }
}

