/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.supplier.TestSupplierActBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSupplierActItemBuilder<P extends TestSupplierActBuilder<P, B>, B extends TestSupplierActItemBuilder<P, B>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private final P parent;
    private Product product;
    private ValueStrategy reorderCode = ValueStrategy.unset();
    private ValueStrategy reorderDescription = ValueStrategy.unset();
    private ValueStrategy packageSize = ValueStrategy.unset();
    private ValueStrategy packageUnits = ValueStrategy.unset();
    private ValueStrategy quantity = ValueStrategy.unset();
    private ValueStrategy unitPrice = ValueStrategy.unset();
    private ValueStrategy listPrice = ValueStrategy.unset();
    private ValueStrategy tax = ValueStrategy.unset();

    public TestSupplierActItemBuilder(String archetype, P parent, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
        this.parent = parent;
    }

    public TestSupplierActItemBuilder(FinancialAct object, P parent, ArchetypeService service) {
        super(object, service);
        this.parent = parent;
    }

    public B product(Product product) {
        this.product = product;
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B reorderCode(String reorderCode) {
        this.reorderCode = ValueStrategy.value(reorderCode);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B reorderDescription(String reorderDescription) {
        this.reorderDescription = ValueStrategy.value(reorderDescription);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B packageSize(int packageSize) {
        this.packageSize = ValueStrategy.value(packageSize);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B packageUnits(String packageUnits) {
        this.packageUnits = ValueStrategy.value(packageUnits);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public B quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B unitPrice(int unitPrice) {
        return this.unitPrice(BigDecimal.valueOf(unitPrice));
    }

    public B unitPrice(BigDecimal unitPrice) {
        this.unitPrice = ValueStrategy.value(unitPrice);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B listPrice(BigDecimal listPrice) {
        this.listPrice = ValueStrategy.value(listPrice);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public B tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (B)((TestSupplierActItemBuilder)this.getThis());
    }

    public P add() {
        FinancialAct item = (FinancialAct)this.build(false);
        ((TestSupplierActBuilder)this.parent).add(item);
        return this.parent;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        String code;
        super.build(object, bean, toSave, toRemove);
        if (this.product != null) {
            bean.setTarget("product", (IMObject)this.product);
        }
        this.reorderCode.setValue(bean, "reorderCode");
        this.reorderDescription.setValue(bean, "reorderDescription");
        this.packageSize.setValue(bean, "packageSize");
        if (this.packageUnits.isSet() && (code = this.packageUnits.toString()) != null) {
            ((TestLookupBuilder)new TestLookupBuilder("lookup.uom", this.getService()).code(code)).build();
        }
        this.packageUnits.setValue(bean, "packageUnits");
        this.quantity.setValue(bean, "quantity");
        this.unitPrice.setValue(bean, "unitPrice");
        this.listPrice.setValue(bean, "listPrice");
        this.tax.setValue(bean, "tax");
        this.getService().deriveValues((IMObject)object);
    }
}

