/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.security;

import java.util.ArrayList;
import java.util.Set;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestFirewallBuilder
extends AbstractTestIMObjectBuilder<Entity, TestFirewallBuilder> {
    private FirewallSettings.AccessType accessType;
    private ValueStrategy enableMfa = ValueStrategy.unset();
    private String[] allowedAddresses;

    public TestFirewallBuilder(ArchetypeService service) {
        super("entity.globalSettingsFirewall", Entity.class, service);
    }

    public TestFirewallBuilder accessType(FirewallSettings.AccessType accessType) {
        this.accessType = accessType;
        return this;
    }

    public TestFirewallBuilder enableMultifactorAuthentication(boolean enable) {
        this.enableMfa = ValueStrategy.value(enable);
        return this;
    }

    public TestFirewallBuilder allowedAddresses(String ... allowedAddresses) {
        this.allowedAddresses = allowedAddresses;
        return this;
    }

    @Override
    protected Entity getObject(String archetype) {
        Entity entity = (Entity)this.getExisting();
        if (entity == null) {
            entity = this.getSingleton(archetype, Entity.class);
        }
        return entity;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        FirewallSettings settings = new FirewallSettings(object, this.getService());
        if (this.accessType != null) {
            settings.setAccessType(this.accessType);
        }
        this.enableMfa.setValue(bean, "enableMfa");
        if (this.allowedAddresses != null) {
            ArrayList<FirewallEntry> entries = new ArrayList<FirewallEntry>();
            for (String address : this.allowedAddresses) {
                entries.add(new FirewallEntry(address));
            }
            settings.setAllowedAddresses(entries);
        }
    }
}

