/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestWorkListBuilder
extends AbstractTestEntityBuilder<Entity, TestWorkListBuilder> {
    private final Map<Entity, Pair<Integer, Boolean>> taskTypes = new HashMap<Entity, Pair<Integer, Boolean>>();
    private final List<Entity> templates = new ArrayList<Entity>();
    private ValueStrategy maxSlots = ValueStrategy.unset();

    public TestWorkListBuilder(ArchetypeService service) {
        super("party.organisationWorkList", Entity.class, service);
        this.name(ValueStrategy.random("zworklist"));
    }

    public TestWorkListBuilder(Entity workList, ArchetypeService service) {
        super(workList, service);
    }

    public TestWorkListBuilder maxSlots(int maxSlots) {
        this.maxSlots = ValueStrategy.value(maxSlots);
        return this;
    }

    public TestWorkListBuilder taskTypes(Entity ... taskTypes) {
        for (Entity taskType : taskTypes) {
            this.addTaskType(taskType, 1, false);
        }
        return this;
    }

    public TestWorkListBuilder addTaskType(Entity taskType, int noSlots, boolean isDefault) {
        this.taskTypes.put(taskType, (Pair<Integer, Boolean>)new ImmutablePair((Object)noSlots, (Object)isDefault));
        return this;
    }

    public TestWorkListBuilder addTemplates(Entity ... templates) {
        this.templates.addAll(Arrays.asList(templates));
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Relationship relationship;
        super.build(object, bean, toSave, toRemove);
        this.maxSlots.setValue(bean, "maxSlots");
        for (Map.Entry<Entity, Pair<Integer, Boolean>> taskType : this.taskTypes.entrySet()) {
            relationship = bean.addTarget("taskTypes", (IMObject)taskType.getKey());
            IMObjectBean relBean = this.getBean((IMObject)relationship);
            relBean.setValue("noSlots", taskType.getValue().getLeft());
            relBean.setValue("default", taskType.getValue().getRight());
        }
        for (Entity template : this.templates) {
            relationship = bean.addTarget("templates", (IMObject)template);
            template.addEntityRelationship((EntityRelationship)relationship);
            toSave.add((IMObject)template);
        }
    }
}

