/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import org.junit.Assert;
import org.openvpms.archetype.test.builder.act.AbstractTestActVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestTaskVerifier
extends AbstractTestActVerifier<Act, TestTaskVerifier> {
    private Reference workList;
    private Reference taskType;
    private Reference customer;
    private Reference patient;
    private ValueStrategy notes = ValueStrategy.unset();

    public TestTaskVerifier(ArchetypeService service) {
        super(service);
        this.archetype("act.customerTask");
        this.status("PENDING");
    }

    public TestTaskVerifier worklist(Entity workList) {
        this.workList = this.getReference((IMObject)workList);
        return this;
    }

    public TestTaskVerifier taskType(Entity taskType) {
        this.taskType = this.getReference((IMObject)taskType);
        return this;
    }

    public TestTaskVerifier customer(Party customer) {
        this.customer = this.getReference((IMObject)customer);
        return this;
    }

    public TestTaskVerifier patient(Party patient) {
        this.patient = this.getReference((IMObject)patient);
        return this;
    }

    public TestTaskVerifier notes(String notes) {
        this.notes = ValueStrategy.value(notes);
        return this;
    }

    @Override
    protected void verify(Act object, IMObjectBean bean) {
        super.verify(object, bean);
        Assert.assertEquals((Object)this.workList, (Object)bean.getTargetRef("worklist"));
        Assert.assertEquals((Object)this.taskType, (Object)bean.getTargetRef("taskType"));
        Assert.assertEquals((Object)this.customer, (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)this.patient, (Object)bean.getTargetRef("patient"));
        this.checkEquals(this.notes, bean.getString("notes"));
    }
}

