/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Date;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentTypeBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCageTypeBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarBlockBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarBlockTypeBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarEventBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestRosterAreaBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestRosterEventBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestScheduleBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestScheduleViewBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSyncIdBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestTaskTypeBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestWorkListBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestWorkListViewBuilder;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSchedulingFactory {
    private final AppointmentRules rules;
    private final TestProductFactory productFactory;
    private final IArchetypeRuleService service;

    public TestSchedulingFactory(AppointmentRules rules, TestProductFactory productFactory, IArchetypeRuleService service) {
        this.rules = rules;
        this.productFactory = productFactory;
        this.service = service;
    }

    public Entity createSchedule(Party location) {
        return (Entity)this.newSchedule().location(location).build();
    }

    public TestScheduleBuilder newSchedule() {
        return new TestScheduleBuilder((ArchetypeService)this.service);
    }

    public TestScheduleBuilder updateSchedule(Entity schedule) {
        return new TestScheduleBuilder(schedule, (ArchetypeService)this.service);
    }

    public Entity createAppointmentType() {
        return (Entity)this.newAppointmentType().build();
    }

    public Entity createAppointmentType(String name) {
        return (Entity)((TestAppointmentTypeBuilder)this.newAppointmentType().name(name)).build();
    }

    public TestAppointmentTypeBuilder newAppointmentType() {
        return new TestAppointmentTypeBuilder((ArchetypeService)this.service);
    }

    public TestAppointmentTypeBuilder updateAppointmentType(Entity appointmentType) {
        return new TestAppointmentTypeBuilder(appointmentType, (ArchetypeService)this.service);
    }

    public Entity createCageType() {
        return (Entity)this.newCageType().firstPetProductDay(this.productFactory.createService()).build();
    }

    public TestCageTypeBuilder newCageType() {
        return new TestCageTypeBuilder((ArchetypeService)this.service);
    }

    public Entity createRosterArea(Party location) {
        return (Entity)this.newRosterArea().location(location).build();
    }

    public Entity createRosterArea(Party location, Entity ... schedules) {
        return (Entity)this.newRosterArea().location(location).schedules(schedules).build();
    }

    public TestRosterAreaBuilder newRosterArea() {
        return new TestRosterAreaBuilder((ArchetypeService)this.service);
    }

    public TestRosterEventBuilder newRosterEvent() {
        return new TestRosterEventBuilder((ArchetypeService)this.service);
    }

    public ActIdentity createSyncId() {
        return new TestSyncIdBuilder((ArchetypeService)this.service).build();
    }

    public TestSyncIdBuilder updateSyncId(ActIdentity identity) {
        return new TestSyncIdBuilder(identity, (ArchetypeService)this.service);
    }

    public Entity createScheduleView(Entity ... schedules) {
        return (Entity)this.newScheduleView().schedules(schedules).build();
    }

    public TestScheduleViewBuilder newScheduleView() {
        return new TestScheduleViewBuilder((ArchetypeService)this.service);
    }

    public TestAppointmentBuilder newAppointment() {
        return new TestAppointmentBuilder(this.rules, this.service);
    }

    public TestAppointmentBuilder updateAppointment(Act appointment) {
        return new TestAppointmentBuilder(appointment, this.rules, (ArchetypeService)this.service);
    }

    public Entity createTaskType() {
        return (Entity)this.newTaskType().build();
    }

    public Entity createWorkList() {
        return (Entity)this.newWorkList().build();
    }

    public TestWorkListBuilder newWorkList() {
        return new TestWorkListBuilder((ArchetypeService)this.service);
    }

    public Entity createWorkListView(Entity ... worklists) {
        return (Entity)this.newWorkListView().worklists(worklists).build();
    }

    public TestWorkListViewBuilder newWorkListView() {
        return new TestWorkListViewBuilder((ArchetypeService)this.service);
    }

    public TestTaskTypeBuilder newTaskType() {
        return new TestTaskTypeBuilder((ArchetypeService)this.service);
    }

    public TestTaskBuilder newTask() {
        return new TestTaskBuilder((ArchetypeService)this.service);
    }

    public Act createCalendarEvent(Entity calendar, Date startTime, Date endTime) {
        return (Act)((TestCalendarEventBuilder)((TestCalendarEventBuilder)((TestCalendarEventBuilder)this.newCalendarEvent().schedule(calendar)).startTime(startTime)).endTime(endTime)).build();
    }

    public TestCalendarEventBuilder newCalendarEvent() {
        return new TestCalendarEventBuilder((ArchetypeService)this.service);
    }

    public TestCalendarBlockBuilder newCalendarBlock() {
        return new TestCalendarBlockBuilder((ArchetypeService)this.service);
    }

    public Entity createCalendarBlockType() {
        return (Entity)this.newCalenderBlockType().build();
    }

    public TestCalendarBlockTypeBuilder newCalenderBlockType() {
        return new TestCalendarBlockTypeBuilder((ArchetypeService)this.service);
    }
}

