/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestScheduleBuilder
extends AbstractTestEntityBuilder<Entity, TestScheduleBuilder> {
    private final Map<Entity, Pair<Integer, Boolean>> appointmentTypes = new HashMap<Entity, Pair<Integer, Boolean>>();
    private final List<Entity> workLists = new ArrayList<Entity>();
    private final List<Entity> templates = new ArrayList<Entity>();
    private Party location;
    private ValueStrategy start = ValueStrategy.unset();
    private ValueStrategy end = ValueStrategy.unset();
    private ValueStrategy slotSize = ValueStrategy.unset();
    private ValueStrategy slotUnits = ValueStrategy.unset();
    private ValueStrategy maxDuration = ValueStrategy.unset();
    private ValueStrategy maxDurationUnits = ValueStrategy.unset();
    private ValueStrategy onlineBooking = ValueStrategy.unset();
    private ValueStrategy sendReminders = ValueStrategy.unset();
    private Entity cageType;

    public TestScheduleBuilder(ArchetypeService service) {
        super("party.organisationSchedule", Entity.class, service);
        this.name(ValueStrategy.random("zschedule"));
    }

    public TestScheduleBuilder(Entity schedule, ArchetypeService service) {
        super(schedule, service);
    }

    public TestScheduleBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestScheduleBuilder slotSize(int slotSize) {
        return this.slotSize(slotSize, DateUnits.MINUTES);
    }

    public TestScheduleBuilder slotSize(int size, DateUnits units) {
        this.slotSize = ValueStrategy.value(size);
        this.slotUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestScheduleBuilder maxDuration(int duration, DateUnits units) {
        this.maxDuration = ValueStrategy.value(duration);
        this.maxDurationUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestScheduleBuilder noMaxDuration() {
        this.maxDuration = ValueStrategy.value(null);
        this.maxDurationUnits = ValueStrategy.value(null);
        return this;
    }

    public TestScheduleBuilder unlimitedDuration() {
        this.maxDuration = ValueStrategy.value(null);
        this.maxDurationUnits = ValueStrategy.value(null);
        return this;
    }

    public TestScheduleBuilder times(int startHour, int endHour) {
        this.start = ValueStrategy.value(Time.valueOf(String.format("%02d:00:00", startHour)));
        this.end = ValueStrategy.value(Time.valueOf(String.format("%02d:00:00", endHour)));
        return this;
    }

    public TestScheduleBuilder times(String startTime, String endTime) {
        this.start = startTime != null ? ValueStrategy.value(Time.valueOf(startTime + ":00")) : ValueStrategy.value(null);
        this.end = endTime != null ? ValueStrategy.value(Time.valueOf(endTime + ":00")) : ValueStrategy.value(null);
        return this;
    }

    public TestScheduleBuilder cageType(Entity cageType) {
        this.cageType = cageType;
        return this;
    }

    public TestScheduleBuilder appointmentTypes(Entity ... appointmentTypes) {
        for (Entity appointmentType : appointmentTypes) {
            this.addAppointmentType(appointmentType, 1, false);
        }
        return this;
    }

    public TestScheduleBuilder addAppointmentType(Entity appointmentType, int noSlots, boolean isDefault) {
        this.appointmentTypes.put(appointmentType, (Pair<Integer, Boolean>)new ImmutablePair((Object)noSlots, (Object)isDefault));
        return this;
    }

    public TestScheduleBuilder onlineBooking() {
        return this.onlineBooking(true);
    }

    public TestScheduleBuilder onlineBooking(boolean onlineBooking) {
        this.onlineBooking = ValueStrategy.value(onlineBooking);
        return this;
    }

    public TestScheduleBuilder sendReminders(boolean sendReminders) {
        this.sendReminders = ValueStrategy.value(sendReminders);
        return this;
    }

    public TestScheduleBuilder addWorkLists(Entity ... workLists) {
        this.workLists.addAll(Arrays.asList(workLists));
        return this;
    }

    public TestScheduleBuilder addTemplates(Entity ... templates) {
        this.templates.addAll(Arrays.asList(templates));
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Relationship relationship;
        super.build(object, bean, toSave, toRemove);
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        this.slotSize.setValue(bean, "slotSize");
        this.slotUnits.setValue(bean, "slotUnits");
        this.maxDuration.setValue(bean, "maxDuration");
        this.maxDurationUnits.setValue(bean, "maxDurationUnits");
        this.start.setValue(bean, "startTime");
        this.end.setValue(bean, "endTime");
        this.onlineBooking.setValue(bean, "onlineBooking");
        this.sendReminders.setValue(bean, "sendReminders");
        if (this.cageType != null) {
            bean.setTarget("cageType", (IMObject)this.cageType);
        }
        for (Map.Entry<Entity, Pair<Integer, Boolean>> appointmentType : this.appointmentTypes.entrySet()) {
            relationship = bean.addTarget("appointmentTypes", (IMObject)appointmentType.getKey());
            IMObjectBean relBean = this.getBean((IMObject)relationship);
            relBean.setValue("noSlots", appointmentType.getValue().getLeft());
            relBean.setValue("default", appointmentType.getValue().getRight());
        }
        for (Entity workList : this.workLists) {
            relationship = bean.addTarget("workLists", (IMObject)workList);
            workList.addEntityRelationship((EntityRelationship)relationship);
            toSave.add((IMObject)workList);
        }
        for (Entity template : this.templates) {
            relationship = bean.addTarget("templates", (IMObject)template);
            template.addEntityRelationship((EntityRelationship)relationship);
            toSave.add((IMObject)template);
        }
    }
}

