/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.scheduling.AbstractTestScheduleActBuilder;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestAppointmentBuilder
extends AbstractTestScheduleActBuilder<TestAppointmentBuilder> {
    private final AppointmentRules rules;
    private Entity schedule;
    private Entity appointmentType;
    private ValueStrategy arrivalTime = ValueStrategy.unset();
    private ValueStrategy sendReminder = ValueStrategy.unset();
    private ValueStrategy reminderSent = ValueStrategy.unset();
    private ValueStrategy reminderError = ValueStrategy.unset();
    private Act task;
    private Act event;
    private ValueStrategy smsStatus = ValueStrategy.unset();

    public TestAppointmentBuilder(AppointmentRules rules, IArchetypeRuleService service) {
        super("act.customerAppointment", (ArchetypeService)service);
        this.rules = rules;
    }

    public TestAppointmentBuilder(Act appointment, AppointmentRules rules, ArchetypeService service) {
        super(appointment, service);
        this.rules = rules;
    }

    public TestAppointmentBuilder schedule(Entity schedule) {
        this.schedule = schedule;
        return this;
    }

    public TestAppointmentBuilder appointmentType(Entity appointmentType) {
        this.appointmentType = appointmentType;
        return this;
    }

    public TestAppointmentBuilder arrivalTime(String arrivalTime) {
        return this.arrivalTime(this.parseDate(arrivalTime));
    }

    public TestAppointmentBuilder arrivalTime(Date arrivalTime) {
        this.arrivalTime = ValueStrategy.value(arrivalTime);
        return this;
    }

    public TestAppointmentBuilder sendReminder(boolean sendReminder) {
        this.sendReminder = ValueStrategy.value(sendReminder);
        return this;
    }

    public TestAppointmentBuilder reminderSent(Date reminderSent) {
        this.reminderSent = ValueStrategy.value(reminderSent);
        return this;
    }

    public TestAppointmentBuilder reminderError(String reminderError) {
        this.reminderError = ValueStrategy.value(reminderError);
        return this;
    }

    public TestAppointmentBuilder task(Act task) {
        this.task = task;
        return this;
    }

    public TestAppointmentBuilder event(Act event) {
        this.event = event;
        return this;
    }

    public TestAppointmentBuilder smsStatus(String smsStatus) {
        this.smsStatus = ValueStrategy.value(smsStatus);
        return this;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        Date startTime = object.getActivityStartTime();
        Date endTime = object.getActivityEndTime();
        if (endTime == null && startTime != null && this.schedule != null && this.appointmentType != null) {
            endTime = this.rules.calculateEndTime(startTime, this.schedule, this.appointmentType);
            object.setActivityEndTime(endTime);
        }
        if (this.schedule != null) {
            bean.setTarget("schedule", (IMObject)this.schedule);
        }
        if (this.appointmentType != null) {
            bean.setTarget("appointmentType", (IMObject)this.appointmentType);
        }
        this.arrivalTime.setValue(bean, "arrivalTime");
        this.sendReminder.setValue(bean, "sendReminder");
        this.reminderSent.setValue(bean, "reminderSent");
        this.reminderError.setValue(bean, "reminderError");
        if (this.task != null) {
            bean.addTarget("tasks", (IMObject)this.task, "appointments");
            toSave.add((IMObject)this.task);
        }
        if (this.event != null) {
            bean.addTarget("event", (IMObject)this.event, "appointment");
            toSave.add((IMObject)this.event);
        }
        this.smsStatus.setValue(bean, "smsStatus");
    }
}

