/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.archetype.test.builder.product.TestTemplateIncludeBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestTemplateProductBuilder
extends TestProductBuilder<TestTemplateProductBuilder> {
    private final List<EntityLink> includes = new ArrayList<EntityLink>();
    private String invoiceNote;
    private String visitNote;

    public TestTemplateProductBuilder(ArchetypeService service) {
        super("product.template", service);
    }

    public TestTemplateProductBuilder(Product object, ArchetypeService service) {
        super(object, service);
    }

    public TestTemplateProductBuilder invoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
        return this;
    }

    public TestTemplateProductBuilder visitNote(String visitNote) {
        this.visitNote = visitNote;
        return this;
    }

    public TestTemplateIncludeBuilder newInclude() {
        return new TestTemplateIncludeBuilder(this, this.getService());
    }

    @Override
    protected void build(Product object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.invoiceNote != null) {
            bean.setValue("invoiceNote", (Object)this.invoiceNote);
        }
        if (this.visitNote != null) {
            bean.setValue("visitNote", (Object)this.visitNote);
        }
        if (!this.includes.isEmpty()) {
            int sequence = this.getNextSequence(bean, "includes");
            Reference reference = object.getObjectReference();
            for (EntityLink include : this.includes) {
                include.setSource(reference);
                IMObjectBean includeBean = this.getBean((IMObject)include);
                includeBean.setValue("sequence", (Object)sequence++);
                object.addEntityLink(include);
            }
            this.includes.clear();
        }
    }

    void include(EntityLink link) {
        this.includes.add(link);
    }
}

