/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestProductTaskBuilder<P extends TestProductBuilder<P>>
extends AbstractTestIMObjectBuilder<EntityLink, TestProductTaskBuilder<P>> {
    private final P parent;
    private Entity taskType;
    private Entity workList;
    private ValueStrategy interactive = ValueStrategy.unset();
    private ValueStrategy start = ValueStrategy.unset();
    private ValueStrategy units = ValueStrategy.unset();

    public TestProductTaskBuilder(P parent, ArchetypeService service) {
        super("entityLink.productTask", EntityLink.class, service);
        this.parent = parent;
    }

    public TestProductTaskBuilder<P> taskType(Entity taskType) {
        this.taskType = taskType;
        return this;
    }

    public TestProductTaskBuilder<P> workList(Entity workList) {
        this.workList = workList;
        return this;
    }

    @Override
    public EntityLink build() {
        return (EntityLink)this.build(false);
    }

    public P add() {
        ((TestProductBuilder)this.parent).addProductTask(this.build());
        return this.parent;
    }

    public TestProductTaskBuilder<P> interactive(boolean interactive) {
        this.interactive = ValueStrategy.value(interactive);
        return this;
    }

    public TestProductTaskBuilder<P> start(int period, DateUnits units) {
        this.start = ValueStrategy.value(period);
        this.units = ValueStrategy.value(units != null ? units.toString() : null);
        return this;
    }

    @Override
    protected void build(EntityLink object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.taskType != null) {
            object.setTarget(this.taskType.getObjectReference());
        }
        if (this.workList != null) {
            bean.setValue("worklist", (Object)this.workList.getObjectReference());
        }
        this.start.setValue(bean, "start");
        this.units.setValue(bean, "startUnits");
        this.interactive.setValue(bean, "interactive");
    }
}

