/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestProductSupplierBuilder<P extends TestProductBuilder<P>>
extends AbstractTestIMObjectBuilder<EntityLink, TestProductSupplierBuilder<P>> {
    private final P parent;
    private Party supplier;
    private ValueStrategy preferred = ValueStrategy.unset();
    private ValueStrategy packageSize = ValueStrategy.unset();
    private ValueStrategy listPrice = ValueStrategy.unset();
    private ValueStrategy nettPrice = ValueStrategy.unset();
    private ValueStrategy autoPriceUpdate = ValueStrategy.unset();

    public TestProductSupplierBuilder(P parent, ArchetypeService service) {
        super("entityLink.productSupplier", EntityLink.class, service);
        this.parent = parent;
    }

    public TestProductSupplierBuilder<P> supplier(Party supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    public EntityLink build() {
        return (EntityLink)this.build(false);
    }

    public P add() {
        ((TestProductBuilder)this.parent).addProductSupplier(this.build());
        return this.parent;
    }

    public TestProductSupplierBuilder<P> preferred(boolean preferred) {
        this.preferred = ValueStrategy.value(preferred);
        return this;
    }

    public TestProductSupplierBuilder<P> packageSize(int packageSize) {
        this.packageSize = ValueStrategy.value(packageSize);
        return this;
    }

    public TestProductSupplierBuilder<P> listPrice(BigDecimal listPrice) {
        this.listPrice = ValueStrategy.value(listPrice);
        return this;
    }

    public TestProductSupplierBuilder<P> nettPrice(int nettPrice) {
        return this.nettPrice(BigDecimal.valueOf(nettPrice));
    }

    public TestProductSupplierBuilder<P> nettPrice(BigDecimal nettPrice) {
        this.nettPrice = ValueStrategy.value(nettPrice);
        return this;
    }

    public TestProductSupplierBuilder<P> autoPriceUpdate(boolean autoPriceUpdate) {
        this.autoPriceUpdate = ValueStrategy.value(autoPriceUpdate);
        return this;
    }

    @Override
    protected void build(EntityLink object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.supplier != null) {
            object.setTarget(this.supplier.getObjectReference());
        }
        this.preferred.setValue(bean, "preferred");
        this.packageSize.setValue(bean, "packageSize");
        this.listPrice.setValue(bean, "listPrice");
        this.nettPrice.setValue(bean, "nettPrice");
        this.autoPriceUpdate.setValue(bean, "autoPriceUpdate");
    }
}

