/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestProductReminderBuilder<P extends TestProductBuilder<P>>
extends AbstractTestIMObjectBuilder<EntityLink, TestProductReminderBuilder<P>> {
    private final P parent;
    private Entity reminderType;
    private ValueStrategy interactive = ValueStrategy.unset();
    private ValueStrategy period = ValueStrategy.unset();
    private ValueStrategy units = ValueStrategy.unset();

    public TestProductReminderBuilder(P parent, ArchetypeService service) {
        super("entityLink.productReminder", EntityLink.class, service);
        this.parent = parent;
    }

    public TestProductReminderBuilder<P> reminderType(Entity reminderType) {
        this.reminderType = reminderType;
        return this;
    }

    @Override
    public EntityLink build() {
        return (EntityLink)this.build(false);
    }

    public P add() {
        ((TestProductBuilder)this.parent).addProductReminder(this.build());
        return this.parent;
    }

    public TestProductReminderBuilder<P> interactive(boolean interactive) {
        this.interactive = ValueStrategy.value(interactive);
        return this;
    }

    public TestProductReminderBuilder<P> period(int period, DateUnits units) {
        this.period = ValueStrategy.value(period);
        this.units = ValueStrategy.value(units != null ? units.toString() : null);
        return this;
    }

    @Override
    protected void build(EntityLink object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.reminderType != null) {
            object.setTarget(this.reminderType.getObjectReference());
        }
        this.interactive.setValue(bean, "interactive");
        this.period.setValue(bean, "period");
        this.units.setValue(bean, "periodUom");
    }
}

