/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.util.Date;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.product.TestBatchBuilder;
import org.openvpms.archetype.test.builder.product.TestDemographicUpdateBuilder;
import org.openvpms.archetype.test.builder.product.TestDiscountBuilder;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestPriceTemplateProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductTypeBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceRatioCalendarBuilder;
import org.openvpms.archetype.test.builder.product.TestTemplateProductBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestProductFactory {
    private final ArchetypeService service;

    public TestProductFactory(ArchetypeService service) {
        this.service = service;
    }

    public TestProductBuilder<?> newProduct(String archetype) {
        switch (archetype) {
            case "product.medication": {
                return this.newMedication();
            }
            case "product.merchandise": {
                return this.newMerchandise();
            }
            case "product.service": {
                return this.newService();
            }
            case "product.template": {
                return this.newTemplate();
            }
        }
        throw new IllegalArgumentException("Invalid argument 'archetype'" + archetype);
    }

    public Product createMedication() {
        return (Product)this.newMedication().build();
    }

    public Product createMedication(Entity productType) {
        return (Product)((TestMedicationProductBuilder)this.newMedication().type(productType)).build();
    }

    public TestMedicationProductBuilder newMedication() {
        return new TestMedicationProductBuilder(this.service);
    }

    public TestMedicationProductBuilder updateMedication(Product product) {
        return new TestMedicationProductBuilder(product, this.service);
    }

    public Product createMerchandise() {
        return (Product)this.newMerchandise().build();
    }

    public TestMerchandiseProductBuilder newMerchandise() {
        return new TestMerchandiseProductBuilder(this.service);
    }

    public TestMerchandiseProductBuilder updateMerchandise(Product product) {
        return new TestMerchandiseProductBuilder(product, this.service);
    }

    public Product createService() {
        return (Product)this.newService().build();
    }

    public TestServiceProductBuilder newService() {
        return new TestServiceProductBuilder(this.service);
    }

    public TestServiceProductBuilder updateService(Product product) {
        return new TestServiceProductBuilder(product, this.service);
    }

    public Product createTemplate() {
        return (Product)this.newTemplate().build();
    }

    public TestTemplateProductBuilder newTemplate() {
        return new TestTemplateProductBuilder(this.service);
    }

    public TestTemplateProductBuilder updateTemplate(Product product) {
        return new TestTemplateProductBuilder(product, this.service);
    }

    public TestPriceTemplateProductBuilder newPriceTemplate() {
        return new TestPriceTemplateProductBuilder(this.service);
    }

    public TestPriceTemplateProductBuilder updatePriceTemplate(Product product) {
        return new TestPriceTemplateProductBuilder(product, this.service);
    }

    public TestProductBuilder<?> updateProduct(Product product) {
        if (product.isA("product.medication")) {
            return this.updateMedication(product);
        }
        if (product.isA("product.merchandise")) {
            return this.updateMerchandise(product);
        }
        if (product.isA("product.service")) {
            return this.updateService(product);
        }
        if (product.isA("product.template")) {
            return this.updateTemplate(product);
        }
        if (product.isA("product.priceTemplate")) {
            return this.updatePriceTemplate(product);
        }
        throw new IllegalStateException("Unsupported product: " + product.getArchetype());
    }

    public Entity createProductType() {
        return (Entity)this.newProductType().build();
    }

    public Entity createProductType(String name) {
        return (Entity)((TestProductTypeBuilder)this.newProductType().name(name)).build();
    }

    public TestProductTypeBuilder newProductType() {
        return new TestProductTypeBuilder(this.service);
    }

    public Lookup createPricingGroup(String codePrefix) {
        return (Lookup)((TestLookupBuilder)this.newPricingGroup().uniqueCode(codePrefix)).build();
    }

    public TestLookupBuilder newPricingGroup() {
        return new TestLookupBuilder("lookup.pricingGroup", this.service);
    }

    public Entity createServiceRatioCalendar() {
        return (Entity)new TestServiceRatioCalendarBuilder(this.service).build();
    }

    public TestFixedPriceBuilder<?> newFixedPrice() {
        return new TestFixedPriceBuilder(this.service);
    }

    public TestFixedPriceBuilder<?> updateFixedPrice(ProductPrice price) {
        return new TestFixedPriceBuilder(price, this.service);
    }

    public TestUnitPriceBuilder<?> newUnitPrice() {
        return new TestUnitPriceBuilder(this.service);
    }

    public Entity createBatch(Product product, String batchNo, Date expiryDate) {
        return (Entity)this.newBatch().product(product).batchNo(batchNo).expiryDate(expiryDate).build();
    }

    public TestBatchBuilder newBatch() {
        return new TestBatchBuilder(this.service);
    }

    public TestBatchBuilder updateBatch(Entity batch) {
        return new TestBatchBuilder(batch, this.service);
    }

    public TestDiscountBuilder newDiscount() {
        return new TestDiscountBuilder(this.service);
    }

    public Lookup createDemographicUpdate(String expression) {
        return (Lookup)this.newDemographicUpdate().expression(expression).build();
    }

    public Lookup createDemographicUpdate(String node, String expression) {
        return (Lookup)this.newDemographicUpdate().node(node).expression(expression).build();
    }

    public TestDemographicUpdateBuilder newDemographicUpdate() {
        return new TestDemographicUpdateBuilder(this.service);
    }
}

