/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDoseBuilder
extends AbstractTestEntityBuilder<Entity, TestDoseBuilder> {
    private String species;
    private BigDecimal minWeight;
    private BigDecimal maxWeight;
    private BigDecimal rate;
    private BigDecimal quantity;
    private Integer roundTo;
    private TestMedicationProductBuilder parent;

    public TestDoseBuilder(TestMedicationProductBuilder parent, ArchetypeService service) {
        super("entity.productDose", Entity.class, service);
        this.parent = parent;
    }

    public TestDoseBuilder species(String species) {
        this.species = species;
        return this;
    }

    public TestDoseBuilder minWeight(int minWeight) {
        return this.minWeight(BigDecimal.valueOf(minWeight));
    }

    public TestDoseBuilder minWeight(BigDecimal minWeight) {
        this.minWeight = minWeight;
        return this;
    }

    public TestDoseBuilder maxWeight(int maxWeight) {
        return this.maxWeight(BigDecimal.valueOf(maxWeight));
    }

    public TestDoseBuilder maxWeight(BigDecimal maxWeight) {
        this.maxWeight = maxWeight;
        return this;
    }

    public TestDoseBuilder weightRange(int minWeight, int maxWeight) {
        return this.weightRange(BigDecimal.valueOf(minWeight), BigDecimal.valueOf(maxWeight));
    }

    public TestDoseBuilder weightRange(BigDecimal minWeight, BigDecimal maxWeight) {
        this.minWeight(minWeight);
        return this.maxWeight(maxWeight);
    }

    public TestDoseBuilder rate(int rate) {
        return this.rate(BigDecimal.valueOf(rate));
    }

    public TestDoseBuilder rate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    public TestDoseBuilder quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public TestDoseBuilder quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    public TestDoseBuilder roundTo(int roundTo) {
        this.roundTo = roundTo;
        return this;
    }

    public TestMedicationProductBuilder add() {
        return this.parent.addDose((Entity)this.build(false));
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.species != null) {
            object.addClassification(new TestLookupFactory(this.getService()).getSpecies(this.species));
        }
        if (this.minWeight != null) {
            bean.setValue("minWeight", (Object)this.minWeight);
        }
        if (this.maxWeight != null) {
            bean.setValue("maxWeight", (Object)this.maxWeight);
        }
        if (this.rate != null) {
            bean.setValue("rate", (Object)this.rate);
        }
        if (this.quantity != null) {
            bean.setValue("quantity", (Object)this.quantity);
        }
        if (this.roundTo != null) {
            bean.setValue("roundTo", (Object)this.roundTo);
        }
    }
}

