/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestPriceBuilder<P extends TestProductBuilder<P>, B extends AbstractTestPriceBuilder<P, B>>
extends AbstractTestIMObjectBuilder<ProductPrice, B> {
    private final P parent;
    private ValueStrategy cost = ValueStrategy.unset();
    private ValueStrategy markup = ValueStrategy.unset();
    private ValueStrategy price = ValueStrategy.unset();
    private ValueStrategy maxDiscount = ValueStrategy.unset();
    private ValueStrategy fromDate = ValueStrategy.unset();
    private ValueStrategy toDate = ValueStrategy.unset();
    private ValueStrategy notes = ValueStrategy.unset();
    private Lookup[] pricingGroups;

    public AbstractTestPriceBuilder(ProductPrice object, ArchetypeService service) {
        super(object, service);
        this.parent = null;
    }

    public AbstractTestPriceBuilder(P parent, String archetype, ArchetypeService service) {
        super(archetype, ProductPrice.class, service);
        this.parent = parent;
    }

    public B cost(int cost) {
        return this.cost(BigDecimal.valueOf(cost));
    }

    public B cost(String cost) {
        return this.cost(cost != null ? new BigDecimal(cost) : null);
    }

    public B cost(BigDecimal cost) {
        this.cost = ValueStrategy.value(cost);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B markup(int markup) {
        return this.markup(BigDecimal.valueOf(markup));
    }

    public B markup(String markup) {
        return this.markup(markup != null ? new BigDecimal(markup) : null);
    }

    public B markup(BigDecimal markup) {
        this.markup = ValueStrategy.value(markup);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B costAndPrice(int cost, int price) {
        return this.costAndPrice(BigDecimal.valueOf(cost), BigDecimal.valueOf(price));
    }

    public B costAndPrice(int cost, String price) {
        return this.costAndPrice(BigDecimal.valueOf(cost), new BigDecimal(price));
    }

    public B costAndPrice(BigDecimal cost, BigDecimal price) {
        this.cost(cost);
        this.price(price);
        return this.markup(new ProductPriceRules(this.getService()).getMarkup(cost, price));
    }

    public B price(int price) {
        return this.price(BigDecimal.valueOf(price));
    }

    public B price(String price) {
        return this.price(new BigDecimal(price));
    }

    public B price(BigDecimal price) {
        this.price = ValueStrategy.value(price);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B costAndMarkup(int cost, int markup) {
        return this.costAndMarkup(BigDecimal.valueOf(cost), BigDecimal.valueOf(markup));
    }

    public B costAndMarkup(BigDecimal cost, BigDecimal markup) {
        this.cost(cost);
        this.markup(markup);
        return this.price(new ProductPriceRules(this.getService()).getTaxExPrice(cost, markup));
    }

    public B maxDiscount(int maxDiscount) {
        return this.maxDiscount(BigDecimal.valueOf(maxDiscount));
    }

    public B maxDiscount(String maxDiscount) {
        return this.maxDiscount(maxDiscount != null ? new BigDecimal(maxDiscount) : null);
    }

    public B maxDiscount(BigDecimal maxDiscount) {
        this.maxDiscount = ValueStrategy.value(maxDiscount);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B fromDate(Date fromDate) {
        this.fromDate = ValueStrategy.value(fromDate);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B toDate(Date toDate) {
        this.toDate = ValueStrategy.value(toDate);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B allDates() {
        return this.dateRange((Date)null, null);
    }

    public B dateRange(String fromDate, String toDate) {
        return this.dateRange(this.parseDate(fromDate), this.parseDate(toDate));
    }

    public B dateRange(Date fromDate, Date toDate) {
        this.fromDate(fromDate);
        return this.toDate(toDate);
    }

    public B notes(String notes) {
        this.notes = ValueStrategy.value(notes);
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    public B pricingGroups(String ... pricingGroups) {
        Lookup[] lookups = new Lookup[pricingGroups.length];
        if (pricingGroups.length != 0) {
            TestLookupBuilder lookupBuilder = new TestLookupBuilder("lookup.pricingGroup", this.getService());
            for (int i = 0; i < pricingGroups.length; ++i) {
                for (String pricingGroup : pricingGroups) {
                    lookups[i] = (Lookup)((TestLookupBuilder)lookupBuilder.code(pricingGroup)).build();
                }
            }
        }
        return this.pricingGroups(lookups);
    }

    public B pricingGroups(Lookup ... pricingGroups) {
        this.pricingGroups = pricingGroups;
        return (B)((AbstractTestPriceBuilder)this.getThis());
    }

    @Override
    public ProductPrice build() {
        return (ProductPrice)this.build(false);
    }

    public P add() {
        ProductPrice price = this.build();
        ((TestProductBuilder)this.parent).addPrice(price);
        return this.parent;
    }

    @Override
    protected void build(ProductPrice object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        this.price.setValue(bean, "price");
        this.cost.setValue(bean, "cost");
        this.markup.setValue(bean, "markup");
        this.maxDiscount.setValue(bean, "maxDiscount");
        this.fromDate.setValue(bean, "fromDate");
        this.toDate.setValue(bean, "toDate");
        this.notes.setValue(bean, "notes");
        if (this.pricingGroups != null && this.pricingGroups.length != 0) {
            bean.removeValues("pricingGroups");
            for (Lookup pricingGroup : this.pricingGroups) {
                object.addClassification(pricingGroup);
            }
        }
        super.build(object, bean, toSave, toRemove);
    }
}

