/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.paymentprocessor;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorItemBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestPaymentProcessorTransactionBuilder<B extends TestPaymentProcessorTransactionBuilder<B>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private Party customer;
    private BigDecimal amount;
    private Entity paymentProcessor;
    private ValueStrategy transactionMode = ValueStrategy.unset();
    private Entity location;
    private ValueStrategy email = ValueStrategy.unset();

    public TestPaymentProcessorTransactionBuilder(String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
        this.transactionMode(TestPaymentProcessorItemBuilder.TransactionMode.LINK);
    }

    public B customer(Party customer) {
        this.customer = customer;
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    public B amount(int amount) {
        return this.amount(BigDecimal.valueOf(amount));
    }

    public B amount(BigDecimal amount) {
        this.amount = amount;
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    public B paymentProcessor(Entity paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    public B transactionMode(TestPaymentProcessorItemBuilder.TransactionMode transactionMode) {
        this.transactionMode = ValueStrategy.value(transactionMode.toString());
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    public B location(Party location) {
        this.location = location;
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    public B email(String email) {
        this.email = ValueStrategy.value(email);
        return (B)((TestPaymentProcessorTransactionBuilder)this.getThis());
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.amount != null) {
            bean.setValue("amount", (Object)this.amount);
        }
        if (this.paymentProcessor != null) {
            bean.setTarget("paymentProcessor", (IMObject)this.paymentProcessor);
        }
        this.transactionMode.setValue(bean, "transactionMode");
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        this.email.setValue(bean, "email");
    }
}

