/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient.reminder;

import java.io.InputStream;
import java.util.Date;
import org.junit.Assert;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderConfigurationBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderItemBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestReminderFactory {
    private final ReminderRules reminderRules;
    private final ArchetypeService service;
    private final TestDocumentFactory documentFactory;

    public TestReminderFactory(ReminderRules reminderRules, ArchetypeService service, TestDocumentFactory documentFactory) {
        this.reminderRules = reminderRules;
        this.service = service;
        this.documentFactory = documentFactory;
    }

    public Entity createReminderType() {
        return (Entity)this.newReminderType().defaultInterval(1, DateUnits.MONTHS).build();
    }

    public Entity createReminderType(String name) {
        return (Entity)((TestReminderTypeBuilder)this.newReminderType().name(name)).defaultInterval(1, DateUnits.MONTHS).build();
    }

    public TestReminderTypeBuilder newReminderType() {
        return new TestReminderTypeBuilder(this.service);
    }

    public TestReminderTypeBuilder updateReminderType(Entity reminderType) {
        return new TestReminderTypeBuilder(reminderType, this.service);
    }

    public Entity createVaccinationReminderTemplate() {
        return (Entity)this.newVaccinationVaccinationReminderTemplate().build();
    }

    public TestDocumentTemplateBuilder newVaccinationVaccinationReminderTemplate() {
        String file = "/documents/Vaccination Reminders.jrxml";
        String mimeType = "text/xml";
        InputStream stream = TestReminderFactory.class.getResourceAsStream(file);
        Assert.assertNotNull((Object)stream);
        return (TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(file, mimeType);
    }

    public Entity createSMSTemplate(String type, String expression) {
        return (Entity)this.documentFactory.newSMSTemplate("entity.documentTemplateSMSReminder").contentType(type).content(expression).build();
    }

    public Act createReminder(Party patient, Entity reminderType) {
        return (Act)((TestReminderBuilder)this.newReminder().patient(patient)).reminderType(reminderType).build();
    }

    public Act createReminder(Date due, Party patient, Entity reminderType, Act ... items) {
        return (Act)((TestReminderBuilder)this.newReminder().patient(patient)).reminderType(reminderType).dueDate(due).addItems(items).build();
    }

    public TestReminderBuilder newReminder() {
        return new TestReminderBuilder(this.reminderRules, this.service);
    }

    public TestReminderBuilder updateReminder(Act reminder) {
        return new TestReminderBuilder(reminder, this.reminderRules, this.service);
    }

    public TestReminderItemBuilder newEmailReminder() {
        return new TestReminderItemBuilder("act.patientReminderItemEmail", this.service);
    }

    public Act createExportReminder(Date sendDate, Date dueDate) {
        return (Act)this.newExportReminder().sendDate(sendDate).dueDate(dueDate).build();
    }

    public TestReminderItemBuilder newExportReminder() {
        return new TestReminderItemBuilder("act.patientReminderItemExport", this.service);
    }

    public Act createListReminder(Date sendDate, Date dueDate) {
        return (Act)this.newListReminder().sendDate(sendDate).dueDate(dueDate).build();
    }

    public TestReminderItemBuilder newListReminder() {
        return new TestReminderItemBuilder("act.patientReminderItemList", this.service);
    }

    public TestReminderItemBuilder newPrintReminder() {
        return new TestReminderItemBuilder("act.patientReminderItemPrint", this.service);
    }

    public TestReminderItemBuilder newSMSReminder() {
        return new TestReminderItemBuilder("act.patientReminderItemSMS", this.service);
    }

    public Lookup createReminderGroup() {
        return (Lookup)((TestLookupBuilder)new TestLookupFactory(this.service).newLookup("lookup.reminderGroup").uniqueCode("XREMINDERGROUP_")).build();
    }

    public TestReminderConfigurationBuilder newReminderConfiguration() {
        return new TestReminderConfigurationBuilder(this.service);
    }
}

