/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient.reminder;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestReminderConfigurationBuilder
extends AbstractTestEntityBuilder<Entity, TestReminderConfigurationBuilder> {
    private Party location;
    private ValueStrategy emailAttachments = ValueStrategy.unset();
    private Entity customerTemplate;
    private Entity patientTemplate;

    public TestReminderConfigurationBuilder(ArchetypeService service) {
        super("entity.reminderConfigurationType", Entity.class, service);
    }

    public TestReminderConfigurationBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestReminderConfigurationBuilder emailAttachments(boolean emailAttachments) {
        this.emailAttachments = ValueStrategy.value(emailAttachments);
        return this;
    }

    public TestReminderConfigurationBuilder customerTemplate(Entity customerTemplate) {
        this.customerTemplate = customerTemplate;
        return this;
    }

    public TestReminderConfigurationBuilder patientTemplate(Entity patientTemplate) {
        this.patientTemplate = patientTemplate;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        this.emailAttachments.setValue(bean, "emailAttachments");
        if (this.customerTemplate != null) {
            bean.setTarget("customerTemplate", (IMObject)this.customerTemplate);
        }
        if (this.patientTemplate != null) {
            bean.setTarget("patientTemplate", (IMObject)this.patientTemplate);
        }
    }
}

