/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestVisitBuilder
extends AbstractTestPatientActBuilder<Act, TestVisitBuilder> {
    private final List<Act> items = new ArrayList<Act>();
    private final List<FinancialAct> chargeItems = new ArrayList<FinancialAct>();

    public TestVisitBuilder(ArchetypeService service) {
        super("act.patientClinicalEvent", Act.class, service);
    }

    public TestVisitBuilder(Act object, ArchetypeService service) {
        super(object, service);
    }

    public TestVisitBuilder addItem(Act item) {
        this.items.add(item);
        return this;
    }

    public TestVisitBuilder addItems(Act ... items) {
        this.items.addAll(Arrays.asList(items));
        return this;
    }

    public TestVisitBuilder addChargeItems(FinancialAct ... items) {
        this.chargeItems.addAll(Arrays.asList(items));
        return this;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (Act act : this.items) {
            if (act.isA("act.patientClinicalProblem")) {
                bean.addTarget("items", (IMObject)act, "events");
                continue;
            }
            bean.addTarget("items", (IMObject)act, "event");
        }
        this.items.clear();
        for (FinancialAct financialAct : this.chargeItems) {
            bean.addTarget("chargeItems", (IMObject)financialAct);
        }
        this.chargeItems.clear();
    }
}

