/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActVerifier;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPatientAlertVerifier
extends AbstractTestPatientActVerifier<Act, TestPatientAlertVerifier> {
    private ValueStrategy alertType = ValueStrategy.unset();
    private int duration = -1;
    private DateUnits durationUnits;
    private ValueStrategy product = ValueStrategy.unset();

    public TestPatientAlertVerifier(ArchetypeService service) {
        super(service);
        this.archetype("act.patientAlert");
        this.status("IN_PROGRESS");
    }

    public TestPatientAlertVerifier alertType(Entity alertType) {
        this.alertType = ValueStrategy.value(this.getReference((IMObject)alertType));
        IMObjectBean bean = this.getBean((IMObject)alertType);
        if (bean.getString("durationUnits") != null) {
            this.duration = bean.getInt("duration");
            this.durationUnits = DateUnits.fromString((String)bean.getString("durationUnits"));
        } else {
            this.duration = -1;
        }
        return this;
    }

    public TestPatientAlertVerifier calculateEndTime() {
        Date startTime;
        Date endTime = null;
        if (this.duration >= 0 && (startTime = this.getStartTime()) != null) {
            endTime = DateRules.getDate((Date)startTime, (int)this.duration, (DateUnits)this.durationUnits);
        }
        return (TestPatientAlertVerifier)this.endTime(endTime);
    }

    public TestPatientAlertVerifier product(Product product) {
        this.product = ValueStrategy.value(this.getReference((IMObject)product));
        return this;
    }

    @Override
    protected void verify(Act object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkTargetEquals(this.alertType, bean, "alertType");
        this.checkTargetEquals(this.product, bean, "product");
    }
}

