/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPatientAlertTypeBuilder
extends AbstractTestEntityBuilder<Entity, TestPatientAlertTypeBuilder> {
    private ValueStrategy reason = ValueStrategy.unset();
    private ValueStrategy priority = ValueStrategy.unset();
    private ValueStrategy mandatory = ValueStrategy.unset();
    private ValueStrategy duration = ValueStrategy.unset();
    private ValueStrategy durationUnits = ValueStrategy.unset();
    private ValueStrategy interactive = ValueStrategy.unset();
    private String alertTypeCode;

    public TestPatientAlertTypeBuilder(ArchetypeService service) {
        super("entity.patientAlertType", Entity.class, service);
        this.name(ValueStrategy.random("zalerttype"));
    }

    public TestPatientAlertTypeBuilder reason(String reason) {
        this.reason = ValueStrategy.value(reason);
        return this;
    }

    public TestPatientAlertTypeBuilder priority(String priority) {
        this.priority = ValueStrategy.value(priority);
        return this;
    }

    public TestPatientAlertTypeBuilder duration(int duration, DateUnits units) {
        this.duration = ValueStrategy.value(duration);
        this.durationUnits = ValueStrategy.value(units);
        return this;
    }

    public TestPatientAlertTypeBuilder mandatory(boolean mandatory) {
        this.mandatory = ValueStrategy.value(mandatory);
        return this;
    }

    public TestPatientAlertTypeBuilder interactive(boolean interactive) {
        this.interactive = ValueStrategy.value(interactive);
        return this;
    }

    public TestPatientAlertTypeBuilder alertType(String alertTypeCode) {
        this.alertTypeCode = alertTypeCode;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.reason.setValue(bean, "reason");
        this.priority.setValue(bean, "priority");
        this.mandatory.setValue(bean, "mandatoryAlert");
        this.duration.setValue(bean, "duration");
        this.durationUnits.setValue(bean, "durationUnits");
        this.interactive.setValue(bean, "interactive");
        if (this.alertTypeCode != null) {
            Lookup lookup = (Lookup)((TestLookupBuilder)new TestLookupBuilder("lookup.patientAlertType", this.getService()).code(this.alertTypeCode)).build();
            object.addClassification(lookup);
        }
    }
}

