/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.act.LongTextBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationResultBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvestigationResultsBuilder
extends AbstractTestActBuilder<Act, TestInvestigationResultsBuilder> {
    private final TestInvestigationBuilder parent;
    private final LongTextBuilder notesBuilder;
    private final List<TestInvestigationResultBuilder> results = new ArrayList<TestInvestigationResultBuilder>();
    private ValueStrategy resultsId = ValueStrategy.unset();
    private Entity test;
    private ValueStrategy categoryName = ValueStrategy.unset();
    private ValueStrategy notes = ValueStrategy.unset();

    public TestInvestigationResultsBuilder(TestInvestigationBuilder parent, ArchetypeService service) {
        super("act.patientInvestigationResults", Act.class, service);
        this.parent = parent;
        this.notesBuilder = new LongTextBuilder("notes", "longNotes", service);
    }

    public TestInvestigationResultsBuilder resultsId(String resultsId) {
        this.resultsId = ValueStrategy.value(resultsId);
        return this;
    }

    public TestInvestigationResultsBuilder test(Entity test) {
        this.test = test;
        return this;
    }

    public TestInvestigationResultsBuilder categoryName(String categoryName) {
        this.categoryName = ValueStrategy.value(categoryName);
        return this;
    }

    public TestInvestigationResultsBuilder notes(String notes) {
        this.notes = ValueStrategy.value(notes);
        return this;
    }

    public TestInvestigationResultBuilder result() {
        return new TestInvestigationResultBuilder(this, this.getService());
    }

    public TestInvestigationBuilder add() {
        this.parent.addResults(this);
        return this.parent;
    }

    protected void addResult(TestInvestigationResultBuilder result) {
        this.results.add(result);
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.resultsId.setValue(bean, "resultsId");
        if (this.test != null) {
            bean.setTarget("test", (IMObject)this.test);
        }
        this.categoryName.setValue(bean, "categoryName");
        this.notesBuilder.build(this.notes, bean, toSave, toRemove);
        int sequence = this.getNextSequence(bean, "items");
        for (TestInvestigationResultBuilder builder : this.results) {
            Act result = (Act)builder.build(toSave, toRemove);
            if (!result.isNew()) continue;
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)result, "results");
            relationship.setSequence(sequence++);
        }
        this.results.clear();
    }
}

