/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.party;

import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestContactFactory {
    private final ArchetypeService service;

    public TestContactFactory(ArchetypeService service) {
        this.service = service;
    }

    public Contact createEmail(String email, String ... purposes) {
        return this.createEmail(email, false, purposes);
    }

    public Contact createEmail(String email, boolean preferred, String ... purposes) {
        return ((TestEmailContactBuilder)((TestEmailContactBuilder)this.newEmail().email(email).preferred(preferred)).purposes(purposes)).build();
    }

    public TestEmailContactBuilder<?, ?> newEmail() {
        return new TestEmailContactBuilder(this.service);
    }

    public Contact createLocation(String address, String suburbCode, String stateCode, String postCode) {
        return this.newLocation().address(address).suburbCode(suburbCode).stateCode(stateCode).postcode(postCode).build();
    }

    public TestLocationContactBuilder<?, ?> newLocation() {
        return new TestLocationContactBuilder(this.service);
    }

    public TestLocationContactBuilder<?, ?> updateLocation(Contact location) {
        return new TestLocationContactBuilder(location, this.service);
    }

    public Contact createPhone(String phone) {
        return this.newPhone().phone(phone).build();
    }

    public TestPhoneContactBuilder<?, ?> newPhone() {
        return new TestPhoneContactBuilder(this.service);
    }

    public TestPhoneContactBuilder<?, ?> updatePhone(Contact contact) {
        return new TestPhoneContactBuilder(contact, this.service);
    }
}

