/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.party;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.archetype.test.builder.party.TestWebsiteContactBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestPartyBuilder<T extends Party, B extends AbstractTestPartyBuilder<T, B>>
extends AbstractTestEntityBuilder<T, B> {
    private final List<Contact> contacts = new ArrayList<Contact>();

    public AbstractTestPartyBuilder(String archetype, Class<T> type, ArchetypeService service) {
        super(archetype, type, service);
    }

    public AbstractTestPartyBuilder(T object, ArchetypeService service) {
        super(object, service);
    }

    public B addContact(Contact contact) {
        this.contacts.add(contact);
        return (B)((AbstractTestPartyBuilder)this.getThis());
    }

    public B addContacts(Contact ... contacts) {
        for (Contact contact : contacts) {
            this.addContact(contact);
        }
        return (B)((AbstractTestPartyBuilder)this.getThis());
    }

    public B addPhone(String phone, String ... purposes) {
        return (B)((TestPhoneContactBuilder)this.newPhone().phone(phone).purposes(purposes)).sms(false).add();
    }

    public B addMobilePhone(String phone) {
        return (B)((TestPhoneContactBuilder)this.newPhone().phone(phone).purposes("MOBILE")).sms().add();
    }

    public TestPhoneContactBuilder<T, B> newPhone() {
        return new TestPhoneContactBuilder((AbstractTestPartyBuilder)this.getThis(), this.getService());
    }

    public B addEmail(String email, String ... purposes) {
        return (B)((TestEmailContactBuilder)this.newEmail().email(email).purposes(purposes)).add();
    }

    public TestEmailContactBuilder<T, B> newEmail() {
        return new TestEmailContactBuilder((AbstractTestPartyBuilder)this.getThis(), this.getService());
    }

    public B addAddress(String address, String suburbCode, String stateCode, String postCode, String ... purposes) {
        return (B)((TestLocationContactBuilder)this.newLocation(address, suburbCode, stateCode, postCode).purposes(purposes)).add();
    }

    public TestLocationContactBuilder<T, B> newLocation(String address, String suburbCode, String stateCode, String postCode) {
        return this.newLocation().address(address).suburbCode(suburbCode).stateCode(stateCode).postcode(postCode);
    }

    public TestLocationContactBuilder<T, B> newLocation(String address, String suburbCode) {
        return this.newLocation().address(address).suburbCode(suburbCode);
    }

    public TestLocationContactBuilder<T, B> newLocation() {
        return new TestLocationContactBuilder((AbstractTestPartyBuilder)this.getThis(), this.getService());
    }

    public B addWebsite(String url) {
        TestWebsiteContactBuilder builder = new TestWebsiteContactBuilder(this.getService());
        Contact contact = builder.url(url).build();
        this.contacts.add(contact);
        return (B)((AbstractTestPartyBuilder)this.getThis());
    }

    @Override
    protected void build(T object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (Contact contact : this.contacts) {
            object.addContact(contact);
        }
        this.contacts.clear();
    }
}

