/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.object;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;

public class ValueStrategy {
    private final Object value;
    private final boolean prefix;
    private final String suffix;
    private final int maxLength;
    private static final ValueStrategy UNSET = new ValueStrategy(null, false, null, -1);

    private ValueStrategy(Object value, boolean prefix, String suffix, int maxLength) {
        this.value = value;
        this.prefix = prefix;
        this.suffix = suffix;
        this.maxLength = maxLength;
    }

    public Object getValue() {
        Object result = this.value;
        if (this.prefix || this.suffix != null) {
            String str;
            if (this.prefix) {
                str = this.value != null ? TestHelper.randomName(this.value.toString()) : TestHelper.randomName("");
            } else {
                String string = str = this.value != null ? this.value.toString() : "";
            }
            if (this.maxLength > 0) {
                int length = this.maxLength;
                if (this.suffix != null) {
                    length -= this.suffix.length();
                }
                str = StringUtils.truncate((String)str, (int)length);
            }
            if (this.suffix != null) {
                str = str + this.suffix;
            }
            result = str;
        }
        return result;
    }

    public String toString() {
        Object value = this.getValue();
        return value != null ? value.toString() : null;
    }

    public Object setValue(IMObjectBean bean, String name) {
        Object value;
        if (this.isSet()) {
            value = this.getValue();
            bean.setValue(name, value);
        } else {
            value = bean.hasNode(name) ? bean.getValue(name) : null;
        }
        return value;
    }

    public Object reset(IMObjectBean bean, String name) {
        Object value = bean.getDefaultValue(name);
        bean.setValue(name, value);
        return value;
    }

    public boolean isSet() {
        return !this.isUnset();
    }

    public boolean isUnset() {
        return this == UNSET;
    }

    public static ValueStrategy unset() {
        return UNSET;
    }

    @Deprecated
    public boolean useDefault() {
        return this.isUnset();
    }

    @Deprecated
    public static ValueStrategy defaultValue() {
        return ValueStrategy.unset();
    }

    public static ValueStrategy value(Object value) {
        return new ValueStrategy(value, false, null, -1);
    }

    public static ValueStrategy random() {
        return ValueStrategy.random("");
    }

    public static ValueStrategy random(String prefix) {
        return ValueStrategy.random(prefix, null);
    }

    public static ValueStrategy random(String prefix, String suffix) {
        return new ValueStrategy(prefix != null ? prefix : "", true, suffix, -1);
    }

    public static ValueStrategy suffix(String suffix) {
        return new ValueStrategy("", true, suffix, -1);
    }

    public static ValueStrategy random(String prefix, int maxLength) {
        return new ValueStrategy(prefix, true, null, maxLength);
    }

    public static String randomString() {
        return ValueStrategy.random().toString();
    }

    public static String randomString(String prefix) {
        return ValueStrategy.random(prefix).toString();
    }
}

