/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.object;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.object.IMObject;

public class IMObjectGraphVerifier {
    private final Map<String, Integer> counts = new HashMap<String, Integer>();
    private String primaryArchetype;

    public IMObjectGraphVerifier primaryArchetype(String archetype) {
        this.primaryArchetype = archetype;
        return this;
    }

    public IMObjectGraphVerifier count(String archetype, int expected) {
        this.counts.put(archetype, expected);
        return this;
    }

    public void verify(IMObjectGraph graph) {
        Assert.assertNotNull((Object)graph.getPrimary());
        Assert.assertTrue((boolean)graph.getPrimary().isA(this.primaryArchetype));
        ArrayList objects = new ArrayList(graph.getObjects());
        for (Map.Entry<String, Integer> entry : this.counts.entrySet()) {
            String archetype = entry.getKey();
            int count = entry.getValue();
            List matches = objects.stream().filter(object -> object.isA(archetype)).collect(Collectors.toList());
            Assert.assertEquals((String)("Expected " + count + " " + archetype + " but got " + matches.size()), (long)count, (long)matches.size());
            objects.removeAll(matches);
        }
        if (!objects.isEmpty()) {
            Assert.fail((String)("There are unexpected objects in the graph: " + objects.stream().map(IMObject::getArchetype).collect(Collectors.joining(", "))));
        }
    }
}

