/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestLookupBuilder<B extends AbstractTestLookupBuilder<B>>
extends AbstractTestIMObjectBuilder<Lookup, B> {
    private ValueStrategy code;
    private boolean uniqueCode;
    private String builtCode;
    private Lookup source;
    private Boolean isDefault;

    public AbstractTestLookupBuilder(String archetype, ArchetypeService service) {
        super(archetype, Lookup.class, service);
    }

    public B code(String code) {
        return this.code(ValueStrategy.value(code));
    }

    public B code(ValueStrategy code) {
        this.code = ValueStrategy.value(code);
        this.uniqueCode = false;
        return (B)((AbstractTestLookupBuilder)this.getThis());
    }

    public B uniqueCode() {
        return this.uniqueCode("");
    }

    public B uniqueCode(String prefix) {
        this.code = ValueStrategy.random(prefix);
        this.uniqueCode = true;
        return (B)((AbstractTestLookupBuilder)this.getThis());
    }

    public B source(Lookup source) {
        this.source = source;
        return (B)((AbstractTestLookupBuilder)this.getThis());
    }

    public B isDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return (B)((AbstractTestLookupBuilder)this.getThis());
    }

    public static void clearDefault(String archetype, ArchetypeService service) {
        HashSet<IMObject> toSave = new HashSet<IMObject>();
        AbstractTestLookupBuilder.clearDefault(archetype, null, toSave, service);
        if (!toSave.isEmpty()) {
            service.save(toSave);
        }
    }

    @Override
    protected void build(Lookup object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        object.setCode(this.builtCode);
        if (this.source != null) {
            IMObjectBean sourceBean = this.getBean((IMObject)this.source);
            if (object.isNew() || sourceBean.getValue("source", Relationship.class, Predicates.targetEquals((IMObject)object)) == null) {
                sourceBean.addTarget("source", (IMObject)object, "target");
                toSave.add((IMObject)this.source);
            }
        }
        if (this.isDefault != null) {
            bean.setValue("defaultLookup", (Object)this.isDefault);
            if (this.isDefault.booleanValue()) {
                this.clearDefault(object, toSave);
            }
        }
    }

    @Override
    protected Lookup getObject(String archetype) {
        Lookup lookup = null;
        if (this.uniqueCode) {
            do {
                this.builtCode = this.code.toString();
            } while (this.getLookup(archetype, this.builtCode) != null);
        } else {
            this.builtCode = this.code.toString();
            lookup = this.getLookup(archetype, this.builtCode);
        }
        if (lookup == null) {
            lookup = (Lookup)super.getObject(archetype);
        } else {
            lookup.setActive(true);
        }
        return lookup;
    }

    private Lookup getLookup(String archetype, String code) {
        ArchetypeService service = this.getService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Lookup.class);
        Root root = query.from(Lookup.class, new String[]{archetype});
        query.where((Expression)builder.equal((Expression)root.get("code"), (Object)code));
        return (Lookup)service.createQuery(query).getFirstResult();
    }

    private void clearDefault(Lookup object, Set<IMObject> toSave) {
        ArchetypeService service = this.getService();
        AbstractTestLookupBuilder.clearDefault(object.getArchetype(), !object.isNew() ? Long.valueOf(object.getId()) : null, toSave, service);
    }

    private static void clearDefault(String archetype, Long id, Set<IMObject> toSave, ArchetypeService service) {
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Lookup.class);
        Root root = query.from(Lookup.class, new String[]{archetype});
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("defaultLookup"), (Object)true));
        if (id != null) {
            predicates.add(builder.notEqual((Expression)root.get("id"), (Object)id));
        }
        query.where(predicates);
        for (Lookup lookup : service.createQuery(query).getResultList()) {
            lookup.setDefaultLookup(false);
            toSave.add((IMObject)lookup);
        }
    }
}

