/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.laboratory;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDeviceBuilder
extends AbstractTestEntityBuilder<Entity, TestDeviceBuilder> {
    private String deviceIdArchetype;
    private ValueStrategy deviceId;
    private Entity laboratory;
    private Party[] locations;

    public TestDeviceBuilder(ArchetypeService service) {
        this("entity.laboratoryDevice", service);
        this.deviceId(ValueStrategy.random());
    }

    public TestDeviceBuilder(String archetype, ArchetypeService service) {
        super(archetype, Entity.class, service);
        this.name(ValueStrategy.random("zdevice"));
    }

    public TestDeviceBuilder deviceId(ValueStrategy deviceId) {
        return this.deviceId("entityIdentity.laboratoryDeviceTest", deviceId);
    }

    public TestDeviceBuilder deviceId(String archetype, ValueStrategy deviceId) {
        this.deviceIdArchetype = archetype;
        this.deviceId = deviceId;
        return this;
    }

    public TestDeviceBuilder laboratory(Entity laboratory) {
        this.laboratory = laboratory;
        return this;
    }

    public TestDeviceBuilder locations(Party ... locations) {
        this.locations = locations;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.deviceIdArchetype != null && this.deviceId != null) {
            EntityIdentity identity = this.createEntityIdentity(this.deviceIdArchetype, this.deviceId);
            object.addIdentity(identity);
        }
        if (this.laboratory != null) {
            bean.setTarget("laboratory", (IMObject)this.laboratory);
        }
        if (this.locations != null) {
            for (Party location : this.locations) {
                bean.addTarget("locations", (IMObject)location);
            }
        }
    }
}

