/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.job;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestJobBuilder<B extends AbstractTestJobBuilder<B>>
extends AbstractTestEntityBuilder<Entity, B> {
    private User runAs;
    private Entity notify;

    public AbstractTestJobBuilder(String archetype, ArchetypeService service) {
        super(archetype, Entity.class, service);
    }

    public B runAs(User user) {
        this.runAs = user;
        return (B)((AbstractTestJobBuilder)this.getThis());
    }

    public B notify(Entity notify) {
        this.notify = notify;
        return (B)((AbstractTestJobBuilder)this.getThis());
    }

    @Override
    protected Entity getObject(String archetype) {
        Entity job = (Entity)this.getExisting();
        if (job == null && !(job = this.getSingleton(archetype, Entity.class)).isNew()) {
            this.resetValues(job);
        }
        return job;
    }

    protected void resetValues(Entity job) {
        for (EntityLink entityLink : job.getEntityLinks().toArray(new EntityLink[0])) {
            job.removeEntityLink(entityLink);
        }
        for (EntityLink entityLink : job.getEntityRelationships().toArray(new EntityRelationship[0])) {
            job.removeEntityRelationship((EntityRelationship)entityLink);
        }
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.runAs != null) {
            bean.setTarget("runAs", (IMObject)this.runAs);
        }
        if (this.notify != null) {
            bean.setTarget("notify", (IMObject)this.notify);
        }
    }
}

