/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInsurerBuilder
extends AbstractTestPartyBuilder<Party, TestInsurerBuilder> {
    private String insurerIdArchetype;
    private ValueStrategy insurerId;
    private ValueStrategy paymentType = ValueStrategy.unset();
    private Entity insuranceService;

    public TestInsurerBuilder(ArchetypeService service) {
        super("party.supplierInsurer", Party.class, service);
        this.name(ValueStrategy.random("zinsurer"));
    }

    public TestInsurerBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestInsurerBuilder insurerId(String archetype, String insurerId) {
        return this.insurerId(archetype, ValueStrategy.value(insurerId));
    }

    public TestInsurerBuilder insurerId(String archetype, ValueStrategy insurerId) {
        this.insurerIdArchetype = archetype;
        this.insurerId = insurerId;
        return this;
    }

    public TestInsurerBuilder paymentType(String paymentType) {
        this.paymentType = ValueStrategy.value(paymentType);
        return this;
    }

    public TestInsurerBuilder insuranceService(Entity insuranceService) {
        this.insuranceService = insuranceService;
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.insurerIdArchetype != null && this.insurerId != null) {
            object.addIdentity(this.createEntityIdentity(this.insurerIdArchetype, this.insurerId));
        }
        if (this.paymentType.isSet()) {
            Lookup lookup = (Lookup)((TestLookupBuilder)new TestLookupBuilder("lookup.customPaymentType", this.getService()).code(this.paymentType.toString())).build();
            object.addClassification(lookup);
        }
        if (this.insuranceService != null) {
            bean.setTarget("service", (IMObject)this.insuranceService);
        }
    }
}

