/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestClaimAttachmentBuilder
extends AbstractTestActBuilder<DocumentAct, TestClaimAttachmentBuilder> {
    private final TestClaimBuilder parent;
    private ValueStrategy attachment = ValueStrategy.unset();
    private ValueStrategy original = ValueStrategy.unset();

    public TestClaimAttachmentBuilder(TestClaimBuilder parent, ArchetypeService service) {
        super("act.patientInsuranceClaimAttachment", DocumentAct.class, service);
        this.parent = parent;
    }

    public TestClaimAttachmentBuilder attachment(Document attachment) {
        this.attachment = ValueStrategy.value(attachment);
        return this;
    }

    public TestClaimAttachmentBuilder original(Act original) {
        this.original = ValueStrategy.value(original);
        return this;
    }

    public TestClaimBuilder add() {
        this.parent.addAttachment(this);
        return this.parent;
    }

    @Override
    protected void build(DocumentAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.original.isSet()) {
            Act act = (Act)this.original.getValue();
            bean.setTarget("original", (IMObject)act);
            bean.setValue("startTime", (Object)act.getActivityStartTime());
            if (object.getName() == null) {
                bean.setValue("name", (Object)act.getName());
            }
            bean.setValue("type", (Object)act.getArchetype());
        }
        if (this.attachment.isSet()) {
            Document document = (Document)this.attachment.getValue();
            if (document != null) {
                if (object.getName() == null) {
                    bean.setValue("name", (Object)document.getName());
                }
                object.setDocument(document.getObjectReference());
                toSave.add((IMObject)document);
            } else {
                if (object.getDocument() != null) {
                    toRemove.add(object.getDocument());
                }
                object.setDocument(null);
            }
        }
    }
}

