/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.hl7;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.hl7.TestHL7Factory;
import org.openvpms.archetype.test.builder.hl7.TestHL7ReceiverBuilder;
import org.openvpms.archetype.test.builder.hl7.TestHL7SenderBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestHL7PharmacyBuilder
extends AbstractTestEntityBuilder<Entity, TestHL7PharmacyBuilder> {
    private ValueStrategy oneway = ValueStrategy.unset();
    private Entity sender;
    private Entity receiver;
    private Party location;
    private User user;
    private static final String DEFAULT_APP = "OpenVPMS";
    private static final String DEFAULT_FACILITY = "MainClinic";
    private static final String PHARMACY_APP = "PHARMAPP";
    private static final String PHARMACY_FACILITY = "PHARMFACILITY";

    public TestHL7PharmacyBuilder(ArchetypeService service) {
        super("entity.HL7ServicePharmacy", Entity.class, service);
        this.name(ValueStrategy.random("zhl7"));
    }

    public TestHL7PharmacyBuilder oneway() {
        return this.oneway(true);
    }

    public TestHL7PharmacyBuilder oneway(boolean oneway) {
        this.oneway = ValueStrategy.value(oneway);
        return this;
    }

    public TestHL7PharmacyBuilder defaultSenderReceiver() {
        ArchetypeService service = this.getService();
        TestHL7Factory hl7Factory = new TestHL7Factory(service);
        Entity mapping = hl7Factory.getCubexMapping();
        this.sender(this.createDefaultSender(hl7Factory, mapping));
        return this.receiver(this.createReceiver(hl7Factory, mapping));
    }

    public TestHL7PharmacyBuilder defaultSender() {
        ArchetypeService service = this.getService();
        TestHL7Factory hl7Factory = new TestHL7Factory(service);
        Entity mapping = hl7Factory.getCubexMapping();
        return this.sender(this.createDefaultSender(hl7Factory, mapping));
    }

    public TestHL7PharmacyBuilder defaultReceiver() {
        ArchetypeService service = this.getService();
        TestHL7Factory hl7Factory = new TestHL7Factory(service);
        Entity mapping = hl7Factory.getCubexMapping();
        return this.receiver(this.createReceiver(hl7Factory, mapping));
    }

    public TestHL7PharmacyBuilder sender(Entity sender) {
        this.sender = sender;
        return this;
    }

    public TestHL7PharmacyBuilder receiver(Entity receiver) {
        this.receiver = receiver;
        return this;
    }

    public TestHL7PharmacyBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestHL7PharmacyBuilder user(User user) {
        this.user = user;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.oneway.setValue(bean, "oneway");
        if (this.sender != null) {
            bean.setTarget("sender", (IMObject)this.sender);
        }
        if (this.receiver != null) {
            bean.setTarget("receiver", (IMObject)this.receiver);
        }
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        if (this.user != null) {
            bean.setTarget("user", (IMObject)this.user);
        }
    }

    private Entity createDefaultSender(TestHL7Factory hl7Factory, Entity mapping) {
        return (Entity)((TestHL7SenderBuilder)((TestHL7SenderBuilder)((TestHL7SenderBuilder)((TestHL7SenderBuilder)((TestHL7SenderBuilder)((TestHL7SenderBuilder)hl7Factory.newSender().port(0)).sendingApplication(DEFAULT_APP)).sendingFacility(DEFAULT_FACILITY)).receivingApplication(PHARMACY_APP)).receivingFacility(PHARMACY_FACILITY)).mapping(mapping)).build();
    }

    private Entity createReceiver(TestHL7Factory hl7Factory, Entity mapping) {
        return (Entity)((TestHL7ReceiverBuilder)((TestHL7ReceiverBuilder)((TestHL7ReceiverBuilder)((TestHL7ReceiverBuilder)((TestHL7ReceiverBuilder)((TestHL7ReceiverBuilder)hl7Factory.newReceiver().port(0)).sendingApplication(PHARMACY_APP)).sendingFacility(PHARMACY_FACILITY)).receivingApplication(DEFAULT_APP)).receivingFacility(DEFAULT_FACILITY)).mapping(mapping)).build();
    }
}

