/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.hl7;

import org.openvpms.archetype.test.builder.hl7.TestHL7PharmacyBuilder;
import org.openvpms.archetype.test.builder.hl7.TestHL7ReceiverBuilder;
import org.openvpms.archetype.test.builder.hl7.TestHL7SenderBuilder;
import org.openvpms.archetype.test.builder.hl7.TestMappingBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestHL7Factory {
    private final ArchetypeService service;

    public TestHL7Factory(ArchetypeService service) {
        this.service = service;
    }

    public Entity createHL7Pharmacy(Party location, User user) {
        return this.createHL7Pharmacy(location, false, user);
    }

    public Entity createHL7Pharmacy(Party location, boolean oneway, User user) {
        TestHL7PharmacyBuilder builder = this.newHL7Pharmacy();
        builder.location(location).user(user);
        if (oneway) {
            builder.oneway().defaultSender();
        } else {
            builder.defaultSenderReceiver();
        }
        return (Entity)builder.build();
    }

    public TestHL7PharmacyBuilder newHL7Pharmacy() {
        return new TestHL7PharmacyBuilder(this.service);
    }

    public TestHL7SenderBuilder newSender() {
        return new TestHL7SenderBuilder(this.service);
    }

    public TestHL7ReceiverBuilder newReceiver() {
        return new TestHL7ReceiverBuilder(this.service);
    }

    public Entity getCubexMapping() {
        return (Entity)new TestMappingBuilder("entity.HL7MappingCubex", this.service).build();
    }

    public Entity getIDEXXMapping() {
        return (Entity)new TestMappingBuilder("entity.HL7MappingIDEXX", this.service).build();
    }
}

