/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestEntityBuilder<T extends Entity, B extends AbstractTestEntityBuilder<T, B>>
extends AbstractTestIMObjectBuilder<T, B> {
    private final List<EntityIdentity> identities = new ArrayList<EntityIdentity>();
    private final List<Lookup> classifications = new ArrayList<Lookup>();

    public AbstractTestEntityBuilder(String archetype, Class<T> type, ArchetypeService service) {
        super(archetype, type, service);
    }

    public AbstractTestEntityBuilder(T object, ArchetypeService service) {
        super(object, service);
    }

    public B addClassifications(Lookup ... classifications) {
        this.classifications.addAll(Arrays.asList(classifications));
        return (B)((AbstractTestEntityBuilder)this.getThis());
    }

    public B addIdentities(EntityIdentity ... identities) {
        this.identities.addAll(Arrays.asList(identities));
        return (B)((AbstractTestEntityBuilder)this.getThis());
    }

    public B addIdentity(String archetype, String identity) {
        this.identities.add(this.createEntityIdentity(archetype, ValueStrategy.value(identity)));
        return (B)((AbstractTestEntityBuilder)this.getThis());
    }

    @Override
    protected void build(T object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (Lookup classification : this.classifications) {
            object.addClassification(classification);
        }
        for (EntityIdentity identity : this.identities) {
            object.addIdentity(identity);
        }
        this.identities.clear();
    }

    protected void setEndDates(List<? extends PeriodRelationship> relationships) {
        if (relationships.size() > 1) {
            relationships.sort((o1, o2) -> DateRules.compareTo((Date)o1.getActiveStartTime(), (Date)o2.getActiveStartTime()));
            for (int i = 1; i < relationships.size(); ++i) {
                relationships.get(i - 1).setActiveEndTime(relationships.get(i).getActiveStartTime());
            }
        }
    }
}

