/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import org.junit.Assert;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.test.builder.doc.TestDocumentVerifier;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestImageDocumentVerifier
extends TestDocumentVerifier<TestImageDocumentVerifier> {
    private int width;
    private int height;

    public TestImageDocumentVerifier(DocumentHandlers handlers, ArchetypeService service) {
        super(handlers, service);
        this.archetype("document.image");
    }

    public TestImageDocumentVerifier width(int width) {
        this.width = width;
        return this;
    }

    public TestImageDocumentVerifier height(int height) {
        this.height = height;
        return this;
    }

    @Override
    public TestImageDocumentVerifier initialise(Document document) {
        super.initialise(document);
        IMObjectBean bean = this.getService().getBean((IMObject)document);
        this.width(bean.getInt("width"));
        return this.height(bean.getInt("height"));
    }

    @Override
    public void verify(Document document) {
        super.verify(document);
        IMObjectBean bean = this.getService().getBean((IMObject)document);
        Assert.assertEquals((long)this.width, (long)bean.getInt("width"));
        Assert.assertEquals((long)this.height, (long)bean.getInt("height"));
    }
}

