/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.junit.Assert;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentHelper;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestDocumentTemplateBuilder<B extends AbstractTestDocumentTemplateBuilder<B>>
extends AbstractTestEntityBuilder<Entity, B> {
    private final DocumentHandlers handlers;
    private Document document;
    private Document attached;
    private DocumentAct act;
    private DocumentAct usedAct;

    public AbstractTestDocumentTemplateBuilder(String archetype, ArchetypeService service, DocumentHandlers handlers) {
        super(archetype, Entity.class, service);
        this.handlers = handlers;
    }

    protected AbstractTestDocumentTemplateBuilder(Entity template, ArchetypeService service, DocumentHandlers handlers) {
        super(template, service);
        this.handlers = handlers;
    }

    public B blankDocument() {
        return this.document("/documents/template-blank.jrxml", "text/xml");
    }

    public B documentWithParameters() {
        return this.document("/documents/template-parameters.jrxml");
    }

    public B document(String path) {
        return this.document(path, null);
    }

    public B document(File file, String mimeType) {
        return this.document((Document)DocumentHelper.create((File)file, (String)mimeType, (DocumentHandlers)this.handlers));
    }

    public B document(String path, String mimeType) {
        DocumentHandler handler = this.handlers.get(path, mimeType);
        Assert.assertNotNull((Object)handler);
        InputStream stream = this.getClass().getResourceAsStream(path);
        Assert.assertNotNull((Object)stream);
        return this.document((Document)handler.create(path, stream, mimeType, -1));
    }

    public B document(Document document) {
        this.document = document;
        return (B)((AbstractTestDocumentTemplateBuilder)this.getThis());
    }

    public Document getDocument() {
        return this.attached;
    }

    public B templateAct(DocumentAct act) {
        this.act = act;
        return (B)((AbstractTestDocumentTemplateBuilder)this.getThis());
    }

    public DocumentAct getTemplateAct() {
        return this.usedAct;
    }

    protected DocumentHandlers getHandlers() {
        return this.handlers;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.usedAct = null;
        if (this.document != null) {
            ArchetypeService service = this.getService();
            if (this.act == null) {
                this.act = this.create("act.documentTemplate", DocumentAct.class);
            }
            this.act.setDocument(this.document.getObjectReference());
            this.act.setFileName(this.document.getName());
            this.act.setMimeType(this.document.getMimeType());
            this.act.setDescription(DescriptorHelper.getDisplayName((IMObject)this.document, (ArchetypeService)service));
            IMObjectBean actBean = this.getBean((IMObject)this.act);
            actBean.setTarget("template", (IMObject)object);
            toSave.add((IMObject)this.act);
            toSave.add((IMObject)this.document);
            this.attached = this.document;
            this.document = null;
        } else {
            this.attached = null;
        }
        this.usedAct = this.act;
        this.act = null;
    }
}

