/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import org.openvpms.archetype.test.builder.customer.account.TestCashRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestChequeRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCreditRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestDiscountRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestOtherRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestRefundBuilder
extends TestPaymentRefundBuilder<TestRefundBuilder> {
    public TestRefundBuilder(ArchetypeService service) {
        super("act.customerAccountRefund", service);
    }

    public TestRefundBuilder(FinancialAct object, ArchetypeService service) {
        super(object, service);
    }

    @Override
    public TestCashRefundItemBuilder cash() {
        return new TestCashRefundItemBuilder(this, this.getService());
    }

    @Override
    public TestRefundBuilder cash(int amount) {
        return (TestRefundBuilder)((TestCashRefundItemBuilder)this.cash().amount(amount)).add();
    }

    @Override
    public TestRefundBuilder cash(BigDecimal amount) {
        return (TestRefundBuilder)((TestCashRefundItemBuilder)this.cash().amount(amount)).add();
    }

    public TestChequeRefundItemBuilder cheque() {
        return new TestChequeRefundItemBuilder(this, this.getService());
    }

    public TestRefundBuilder cheque(int amount) {
        return this.cheque(BigDecimal.valueOf(amount));
    }

    public TestRefundBuilder cheque(BigDecimal amount) {
        return (TestRefundBuilder)((TestChequeRefundItemBuilder)this.cheque().amount(amount)).add();
    }

    public TestCreditRefundItemBuilder credit() {
        return new TestCreditRefundItemBuilder(this, this.getService());
    }

    public TestRefundBuilder credit(int amount) {
        return this.credit(BigDecimal.valueOf(amount));
    }

    public TestRefundBuilder credit(BigDecimal amount) {
        return (TestRefundBuilder)((TestCreditRefundItemBuilder)this.credit().amount(amount)).add();
    }

    public TestDiscountRefundItemBuilder discount() {
        return new TestDiscountRefundItemBuilder(this, this.getService());
    }

    public TestRefundBuilder discount(int amount) {
        return this.discount(BigDecimal.valueOf(amount));
    }

    public TestRefundBuilder discount(BigDecimal amount) {
        return (TestRefundBuilder)((TestDiscountRefundItemBuilder)this.discount().amount(amount)).add();
    }

    @Override
    public TestEFTRefundItemBuilder eft() {
        return new TestEFTRefundItemBuilder(this, this.getService());
    }

    @Override
    public TestRefundBuilder eft(int amount) {
        return this.eft(BigDecimal.valueOf(amount));
    }

    @Override
    public TestRefundBuilder eft(BigDecimal amount) {
        return (TestRefundBuilder)((TestEFTRefundItemBuilder)this.eft().amount(amount)).add();
    }

    @Override
    public TestPaymentProcessorRefundItemBuilder paymentProcessor() {
        return new TestPaymentProcessorRefundItemBuilder(this, this.getService());
    }

    @Override
    public TestPaymentProcessorRefundItemBuilder paymentProcessor(FinancialAct item) {
        return new TestPaymentProcessorRefundItemBuilder(item, this, this.getService());
    }

    public TestOtherRefundItemBuilder other() {
        return new TestOtherRefundItemBuilder(this, this.getService());
    }

    public TestRefundBuilder other(int amount) {
        return this.other(BigDecimal.valueOf(amount));
    }

    public TestRefundBuilder other(BigDecimal amount) {
        return (TestRefundBuilder)((TestOtherRefundItemBuilder)this.other().amount(amount)).add();
    }
}

