/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerAccountActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCashItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundItemBuilder;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestPaymentRefundBuilder<B extends TestPaymentRefundBuilder<B>>
extends AbstractTestCustomerAccountActBuilder<B> {
    private final List<FinancialAct> items = new ArrayList<FinancialAct>();
    private final List<BiConsumer<FinancialAct, IMObjectBean>> postBuildActions = new ArrayList<BiConsumer<FinancialAct, IMObjectBean>>();
    private List<FinancialAct> builtItems = new ArrayList<FinancialAct>();
    private Entity till;

    protected TestPaymentRefundBuilder(String archetype, ArchetypeService service) {
        super(archetype, service);
    }

    public TestPaymentRefundBuilder(FinancialAct object, ArchetypeService service) {
        super(object, service);
        IMObjectBean bean = this.getBean((IMObject)object);
        this.till = (Entity)bean.getTarget("till", Entity.class);
    }

    public B till(Entity till) {
        this.till = till;
        return (B)((TestPaymentRefundBuilder)this.getThis());
    }

    public abstract <T extends TestCashItemBuilder<B, T>> T cash();

    public B cash(int amount) {
        return (B)((TestCashItemBuilder)((TestPaymentRefundItemBuilder)this.cash()).amount(amount)).add();
    }

    public B cash(BigDecimal amount) {
        return (B)((TestCashItemBuilder)((TestPaymentRefundItemBuilder)this.cash()).amount(amount)).add();
    }

    public abstract <T extends TestEFTItemBuilder<B, T>> T eft();

    public B eft(int amount) {
        return (B)((TestEFTItemBuilder)((TestPaymentRefundItemBuilder)this.eft()).amount(amount)).add();
    }

    public B eft(BigDecimal amount) {
        return (B)((TestEFTItemBuilder)((TestPaymentRefundItemBuilder)this.eft()).amount(amount)).add();
    }

    public B paymentProcessor(Entity paymentProcessor, int amount) {
        return this.paymentProcessor(paymentProcessor, BigDecimal.valueOf(amount));
    }

    public B paymentProcessor(Entity paymentProcessor, BigDecimal amount) {
        return (B)((TestPaymentProcessorItemBuilder)((TestPaymentRefundItemBuilder)((TestPaymentProcessorItemBuilder)this.paymentProcessor()).processor(paymentProcessor)).amount(amount)).add();
    }

    public abstract <T extends TestPaymentProcessorItemBuilder<B, T>> T paymentProcessor();

    public abstract <T extends TestPaymentProcessorItemBuilder<B, T>> T paymentProcessor(FinancialAct var1);

    public B add(FinancialAct ... items) {
        Collections.addAll(this.items, items);
        return (B)((TestPaymentRefundBuilder)this.getThis());
    }

    public List<FinancialAct> getItems() {
        return this.builtItems;
    }

    public void addPostBuildAction(BiConsumer<FinancialAct, IMObjectBean> action) {
        this.postBuildActions.add(action);
    }

    @Override
    public FinancialAct build(boolean save) {
        FinancialAct object = (FinancialAct)super.build(save);
        if (!this.postBuildActions.isEmpty()) {
            IMObjectBean bean = this.getBean((IMObject)object);
            for (BiConsumer<FinancialAct, IMObjectBean> action : this.postBuildActions) {
                action.accept(object, bean);
            }
            this.postBuildActions.clear();
            if (save) {
                bean.save();
            }
        }
        return object;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.till != null) {
            bean.setTarget("till", (IMObject)this.till);
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (FinancialAct item : bean.getTargets("items", FinancialAct.class)) {
            amount = this.sum(amount, item.getTotal());
        }
        for (FinancialAct item : this.items) {
            if (!bean.hasTarget("items", (IMObject)item)) {
                ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
                item.addActRelationship(relationship);
            }
            toSave.add((IMObject)item);
            amount = this.sum(amount, item.getTotal());
        }
        bean.setValue("amount", (Object)amount);
        this.builtItems = new ArrayList<FinancialAct>(this.items);
        this.items.clear();
    }

    private BigDecimal sum(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            value1 = BigDecimal.ZERO;
        }
        if (value2 == null) {
            value2 = BigDecimal.ZERO;
        }
        return value1.add(value2);
    }
}

