/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.customer.account.TestChargeItemVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvoiceItemVerifier
extends TestChargeItemVerifier<TestInvoiceVerifier, TestInvoiceItemVerifier> {
    private final Map<Reference, Reminder> expectedReminders = new HashMap<Reference, Reminder>();
    private final Map<Reference, Alert> expectedAlerts = new HashMap<Reference, Alert>();
    private ValueStrategy batch = ValueStrategy.value(null);
    private ValueStrategy minQuantity = ValueStrategy.value(0);
    private ValueStrategy label = ValueStrategy.value(null);
    private ValueStrategy expiryDate = ValueStrategy.value(null);
    private ValueStrategy visit = ValueStrategy.unset();
    private ValueStrategy receivedQuantity = ValueStrategy.value(null);
    private ValueStrategy returnedQuantity = ValueStrategy.value(null);
    private boolean ignoreMedication = false;

    public TestInvoiceItemVerifier(ArchetypeService service) {
        this(null, service);
    }

    public TestInvoiceItemVerifier(TestInvoiceVerifier parent, ArchetypeService service) {
        super(parent, service);
        this.archetype("act.customerAccountInvoiceItem");
    }

    public TestInvoiceItemVerifier initialise(Act item) {
        IMObjectBean bean = this.getBean((IMObject)item);
        this.patient(bean.getTargetRef("patient"));
        this.product(bean.getTargetRef("product"));
        this.clinician(bean.getTargetRef("clinician"));
        this.department(bean.getTargetRef("department"));
        this.batch(bean.getTargetRef("batch"));
        this.minQuantity(bean.getBigDecimal("minQuantity"));
        this.quantity(bean.getBigDecimal("quantity"));
        this.fixedCost(bean.getBigDecimal("fixedCost"));
        this.fixedPrice(bean.getBigDecimal("fixedPrice"));
        this.unitCost(bean.getBigDecimal("unitCost"));
        this.unitPrice(bean.getBigDecimal("unitPrice"));
        this.serviceRatio(bean.getBigDecimal("serviceRatio"));
        this.discount(bean.getBigDecimal("discount"));
        this.tax(bean.getBigDecimal("tax"));
        this.total(bean.getBigDecimal("total"));
        Participation templateParticipation = (Participation)bean.getObject("template", Participation.class);
        if (templateParticipation != null) {
            this.template(templateParticipation.getTarget());
            this.group((Integer)this.getBean((IMObject)templateParticipation).getValue("group"));
        } else {
            this.template((Reference)null);
            this.group(null);
        }
        this.createdBy(item.getCreatedBy());
        this.print(bean.getBoolean("print"));
        this.visit = ValueStrategy.value(bean.getSourceRef("event"));
        this.status(item.getStatus());
        this.receivedQuantity(bean.getBigDecimal("receivedQuantity"));
        this.returnedQuantity(bean.getBigDecimal("returnedQuantity"));
        return this;
    }

    public TestInvoiceItemVerifier batch(Entity batch) {
        return this.batch(this.getReference((IMObject)batch));
    }

    public TestInvoiceItemVerifier batch(Reference batch) {
        this.batch = ValueStrategy.value(batch);
        return this;
    }

    public TestInvoiceItemVerifier minQuantity(int minQuantity) {
        return this.minQuantity(BigDecimal.valueOf(minQuantity));
    }

    public TestInvoiceItemVerifier minQuantity(BigDecimal minQuantity) {
        this.minQuantity = ValueStrategy.value(minQuantity);
        return this;
    }

    public TestInvoiceItemVerifier medication(String label, Date expiryDate) {
        this.label = ValueStrategy.value(label);
        this.expiryDate = ValueStrategy.value(expiryDate);
        return this;
    }

    public TestInvoiceItemVerifier visit(Act visit) {
        this.visit = ValueStrategy.value(this.getReference((IMObject)visit));
        return this;
    }

    public TestInvoiceItemVerifier receivedQuantity(int receivedQuantity) {
        return this.receivedQuantity(BigDecimal.valueOf(receivedQuantity));
    }

    public TestInvoiceItemVerifier receivedQuantity(BigDecimal receivedQuantity) {
        this.receivedQuantity = ValueStrategy.value(receivedQuantity);
        return this;
    }

    public TestInvoiceItemVerifier returnedQuantity(BigDecimal returnedQuantity) {
        this.returnedQuantity = ValueStrategy.value(returnedQuantity);
        return this;
    }

    public TestInvoiceItemVerifier addReminder(Entity reminderType, Date dueDate, Date nextDueDate, String status) {
        this.expectedReminders.put(reminderType.getObjectReference(), new Reminder(dueDate, nextDueDate, status));
        return this;
    }

    public TestInvoiceItemVerifier resetReminders() {
        this.expectedReminders.clear();
        return this;
    }

    public TestInvoiceItemVerifier addAlert(Entity alertType, Date endDate, String status) {
        this.expectedAlerts.put(alertType.getObjectReference(), new Alert(alertType, endDate, status));
        return this;
    }

    public TestInvoiceItemVerifier resetAlerts() {
        this.expectedAlerts.clear();
        return this;
    }

    public TestInvoiceItemVerifier ignoreMedication(boolean ignoreMedication) {
        this.ignoreMedication = ignoreMedication;
        return this;
    }

    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkEquals(this.batch, bean.getTargetRef("batch"));
        this.checkEquals(this.minQuantity, (Object)bean.getBigDecimal("minQuantity"));
        this.checkEquals(this.visit, bean.getSourceRef("event"));
        this.checkEquals(this.receivedQuantity, (Object)bean.getBigDecimal("receivedQuantity"));
        this.checkEquals(this.returnedQuantity, (Object)bean.getBigDecimal("returnedQuantity"));
        Reference productRef = this.getProduct();
        if (!this.ignoreMedication && productRef.isA("product.medication")) {
            this.verifyMedication((Act)bean.getTarget("dispensing", Act.class));
        } else {
            Assert.assertNull((Object)bean.getTarget("dispensing", Act.class));
            Assert.assertNull((Object)this.label.getValue());
            Assert.assertNull((Object)this.expiryDate.getValue());
        }
        this.verifyReminders((Act)object, bean.getTargets("reminders", Act.class));
        this.verifyAlerts((Act)object, bean.getTargets("alerts", Act.class));
    }

    private void verifyMedication(Act medication) {
        Assert.assertNotNull((Object)medication);
        IMObjectBean bean = this.getBean((IMObject)medication);
        Assert.assertEquals((Object)this.getPatient(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)this.getProduct(), (Object)bean.getTargetRef("product"));
        this.checkEquals(this.batch, bean.getTargetRef("batch"));
        this.checkEquals(this.getQuantity(), bean.getBigDecimal("quantity"));
        this.checkEquals(this.label, bean.getString("label"));
        this.checkEquals(this.expiryDate, medication.getActivityEndTime());
        Assert.assertEquals((Object)this.getClinician(), (Object)bean.getTargetRef("clinician"));
        this.checkEquals(this.visit, bean.getSourceRef("event"));
    }

    private void verifyReminders(Act item, List<Act> reminders) {
        Assert.assertEquals((long)this.expectedReminders.size(), (long)reminders.size());
        for (Act reminder : reminders) {
            IMObjectBean bean = this.getBean((IMObject)reminder);
            Reminder expected = this.expectedReminders.get(bean.getTargetRef("reminderType"));
            Assert.assertNotNull((Object)expected);
            Assert.assertEquals((Object)this.getPatient(), (Object)bean.getTargetRef("patient"));
            Assert.assertEquals((Object)this.getProduct(), (Object)bean.getTargetRef("product"));
            Date initialTime = DateUtils.truncate((Date)bean.getDate("initialTime"), (int)13);
            Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)item.getActivityStartTime(), (Date)initialTime));
            Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)expected.getDueDate(), (Date)reminder.getActivityEndTime()));
            Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)expected.getNextDueDate(), (Date)reminder.getActivityStartTime()));
            Assert.assertEquals((Object)expected.getStatus(), (Object)reminder.getStatus());
        }
    }

    private void verifyAlerts(Act item, List<Act> alerts) {
        Assert.assertEquals((long)this.expectedAlerts.size(), (long)alerts.size());
        for (Act alert : alerts) {
            IMObjectBean bean = this.getBean((IMObject)alert);
            Alert expected = this.expectedAlerts.get(bean.getTargetRef("alertType"));
            Assert.assertNotNull((Object)expected);
            Assert.assertEquals((Object)item.getActivityStartTime(), (Object)alert.getActivityStartTime());
            Assert.assertEquals((Object)expected.getEndDate(), (Object)alert.getActivityEndTime());
            Assert.assertEquals((Object)this.getPatient(), (Object)bean.getTargetRef("patient"));
            Assert.assertEquals((Object)this.getProduct(), (Object)bean.getTargetRef("product"));
            Assert.assertEquals((Object)this.getClinician(), (Object)bean.getTargetRef("clinician"));
            Assert.assertEquals((Object)expected.getReason(), (Object)alert.getReason());
            Assert.assertEquals((Object)expected.getStatus(), (Object)alert.getStatus());
        }
    }

    private static class Reminder {
        private final Date dueDate;
        private final Date nextDueDate;
        private final String status;

        public Reminder(Date dueDate, Date nextDueDate, String status) {
            this.dueDate = dueDate;
            this.nextDueDate = nextDueDate;
            this.status = status;
        }

        public Date getDueDate() {
            return this.dueDate;
        }

        public Date getNextDueDate() {
            return this.nextDueDate;
        }

        public String getStatus() {
            return this.status;
        }
    }

    private class Alert {
        private final Entity alertType;
        private final Date endDate;
        private final String status;
        private final String reason;

        public Alert(Entity alertType, Date endDate, String status) {
            this.alertType = alertType;
            this.endDate = endDate;
            this.status = status;
            this.reason = TestInvoiceItemVerifier.this.getBean((IMObject)alertType).getString("reason");
        }

        public Entity getAlertType() {
            return this.alertType;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public String getReason() {
            return this.reason;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

