/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvoiceItemBuilder
extends TestCustomerChargeItemBuilder<TestInvoiceBuilder, TestInvoiceItemBuilder> {
    private final List<DocumentAct> investigations = new ArrayList<DocumentAct>();
    private final List<DocumentAct> documents = new ArrayList<DocumentAct>();
    private final List<Act> reminders = new ArrayList<Act>();
    private final List<Act> alerts = new ArrayList<Act>();
    private final List<Act> tasks = new ArrayList<Act>();
    private Act medication;
    private Act visit;

    public TestInvoiceItemBuilder(TestInvoiceBuilder parent, ArchetypeService service) {
        super(parent, "act.customerAccountInvoiceItem", service);
    }

    public TestInvoiceItemBuilder(TestInvoiceBuilder parent, FinancialAct object, ArchetypeService service) {
        super(parent, object, service);
    }

    public TestInvoiceItemBuilder medication(Act medication) {
        this.medication = medication;
        return this;
    }

    public TestInvoiceItemBuilder addInvestigation(DocumentAct investigation) {
        return this.addInvestigations(investigation);
    }

    public TestInvoiceItemBuilder addInvestigations(DocumentAct ... investigations) {
        this.investigations.addAll(Arrays.asList(investigations));
        return this;
    }

    public TestInvoiceItemBuilder addInvestigations(List<DocumentAct> investigations) {
        this.investigations.addAll(investigations);
        return this;
    }

    public TestInvoiceItemBuilder addDocument(DocumentAct document) {
        return this.addDocuments(document);
    }

    public TestInvoiceItemBuilder addDocuments(DocumentAct ... documents) {
        this.documents.addAll(Arrays.asList(documents));
        return this;
    }

    public TestInvoiceItemBuilder addReminder(Act reminder) {
        return this.addReminders(reminder);
    }

    public TestInvoiceItemBuilder addReminders(Act ... reminders) {
        return this.addReminders(Arrays.asList(reminders));
    }

    public TestInvoiceItemBuilder addReminders(List<Act> reminders) {
        this.reminders.addAll(reminders);
        return this;
    }

    public TestInvoiceItemBuilder addAlert(Act alert) {
        return this.addAlerts(alert);
    }

    public TestInvoiceItemBuilder addAlerts(Act ... alerts) {
        return this.addAlerts(Arrays.asList(alerts));
    }

    public TestInvoiceItemBuilder addAlerts(List<Act> alerts) {
        this.alerts.addAll(alerts);
        return this;
    }

    public TestInvoiceItemBuilder addTask(Act task) {
        return this.addTasks(task);
    }

    public TestInvoiceItemBuilder addTasks(Act ... tasks) {
        return this.addTasks(Arrays.asList(tasks));
    }

    public TestInvoiceItemBuilder addTasks(List<Act> tasks) {
        this.tasks.addAll(tasks);
        return this;
    }

    public TestInvoiceItemBuilder visit(Act visit) {
        this.visit = visit;
        return this;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.medication != null) {
            bean.addTarget("dispensing", (IMObject)this.medication, "invoiceItem");
            toSave.add((IMObject)this.medication);
            this.medication = null;
        }
        if (!this.investigations.isEmpty()) {
            for (DocumentAct investigation : this.investigations) {
                bean.addTarget("investigations", (IMObject)investigation, "invoiceItems");
                toSave.add((IMObject)investigation);
            }
            this.investigations.clear();
        }
        if (!this.documents.isEmpty()) {
            for (DocumentAct document : this.documents) {
                bean.addTarget("documents", (IMObject)document, "invoiceItem");
                toSave.add((IMObject)document);
            }
        }
        if (!this.reminders.isEmpty()) {
            for (Act reminder : this.reminders) {
                bean.addTarget("reminders", (IMObject)reminder, "invoiceItem");
                toSave.add((IMObject)reminder);
            }
            this.reminders.clear();
        }
        if (!this.alerts.isEmpty()) {
            for (Act alert : this.alerts) {
                bean.addTarget("alerts", (IMObject)alert, "invoiceItem");
                toSave.add((IMObject)alert);
            }
            this.alerts.clear();
        }
        if (!this.tasks.isEmpty()) {
            for (Act task : this.tasks) {
                bean.addTarget("tasks", (IMObject)task, "invoiceItem");
                toSave.add((IMObject)task);
            }
            this.tasks.clear();
        }
        if (this.visit != null) {
            bean.addSource("event", (IMObject)this.visit, "chargeItems");
            toSave.add((IMObject)this.visit);
            this.visit = null;
        }
    }
}

