/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestEstimateItemVerifier {
    private final ArchetypeService service;
    private Reference patient;
    private Reference product;
    private BigDecimal minimumQuantity = BigDecimal.ZERO;
    private BigDecimal lowQuantity = BigDecimal.ONE;
    private BigDecimal highQuantity = BigDecimal.ONE;
    private BigDecimal fixedPrice = BigDecimal.ZERO;
    private BigDecimal lowUnitPrice = BigDecimal.ZERO;
    private BigDecimal highUnitPrice = BigDecimal.ZERO;
    private BigDecimal lowDiscount = BigDecimal.ZERO;
    private BigDecimal highDiscount = BigDecimal.ZERO;
    private boolean print = true;
    private BigDecimal lowTotal = BigDecimal.ZERO;
    private BigDecimal highTotal = BigDecimal.ZERO;
    private Reference template;
    private Integer group;
    private Reference createdBy;

    public TestEstimateItemVerifier(ArchetypeService service) {
        this.service = service;
    }

    public TestEstimateItemVerifier patient(Party patient) {
        this.patient = patient != null ? patient.getObjectReference() : null;
        return this;
    }

    public TestEstimateItemVerifier product(Product product) {
        this.product = product != null ? product.getObjectReference() : null;
        return this;
    }

    public TestEstimateItemVerifier lowQuantity(int lowQuantity) {
        return this.lowQuantity(BigDecimal.valueOf(lowQuantity));
    }

    public TestEstimateItemVerifier minimumQuantity(int minimumQuantity) {
        return this.minimumQuantity(BigDecimal.valueOf(minimumQuantity));
    }

    public TestEstimateItemVerifier minimumQuantity(BigDecimal minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
        return this;
    }

    public TestEstimateItemVerifier lowQuantity(BigDecimal lowQuantity) {
        this.lowQuantity = lowQuantity;
        return this;
    }

    public TestEstimateItemVerifier highQuantity(int highQuantity) {
        return this.highQuantity(BigDecimal.valueOf(highQuantity));
    }

    public TestEstimateItemVerifier highQuantity(BigDecimal highQuantity) {
        this.highQuantity = highQuantity;
        return this;
    }

    public TestEstimateItemVerifier fixedPrice(int fixedPrice) {
        return this.fixedPrice(BigDecimal.valueOf(fixedPrice));
    }

    public TestEstimateItemVerifier fixedPrice(BigDecimal fixedPrice) {
        this.fixedPrice = fixedPrice;
        return this;
    }

    public TestEstimateItemVerifier lowUnitPrice(int lowUnitPrice) {
        return this.lowUnitPrice(BigDecimal.valueOf(lowUnitPrice));
    }

    public TestEstimateItemVerifier lowUnitPrice(BigDecimal lowUnitPrice) {
        this.lowUnitPrice = lowUnitPrice;
        return this;
    }

    public TestEstimateItemVerifier highUnitPrice(int highUnitPrice) {
        return this.highUnitPrice(BigDecimal.valueOf(highUnitPrice));
    }

    public TestEstimateItemVerifier highUnitPrice(BigDecimal highUnitPrice) {
        this.highUnitPrice = highUnitPrice;
        return this;
    }

    public TestEstimateItemVerifier lowDiscount(int lowDiscount) {
        return this.lowDiscount(BigDecimal.valueOf(lowDiscount));
    }

    public TestEstimateItemVerifier lowDiscount(BigDecimal lowDiscount) {
        this.lowDiscount = lowDiscount;
        return this;
    }

    public TestEstimateItemVerifier highDiscount(int highDiscount) {
        return this.highDiscount(BigDecimal.valueOf(highDiscount));
    }

    public TestEstimateItemVerifier highDiscount(BigDecimal highDiscount) {
        this.highDiscount = highDiscount;
        return this;
    }

    public TestEstimateItemVerifier print(boolean print) {
        this.print = print;
        return this;
    }

    public TestEstimateItemVerifier lowTotal(int lowTotal) {
        return this.lowTotal(BigDecimal.valueOf(lowTotal));
    }

    public TestEstimateItemVerifier lowTotal(BigDecimal lowTotal) {
        this.lowTotal = lowTotal;
        return this;
    }

    public TestEstimateItemVerifier highTotal(int highTotal) {
        return this.highTotal(BigDecimal.valueOf(highTotal));
    }

    public TestEstimateItemVerifier highTotal(BigDecimal highTotal) {
        this.highTotal = highTotal;
        return this;
    }

    public TestEstimateItemVerifier template(Product template) {
        Reference reference = this.template = template != null ? template.getObjectReference() : null;
        if (template == null) {
            this.group = null;
        }
        return this;
    }

    public TestEstimateItemVerifier group(int group) {
        this.group = group;
        return this;
    }

    public TestEstimateItemVerifier createdBy(User createdBy) {
        this.createdBy = createdBy != null ? createdBy.getObjectReference() : null;
        return this;
    }

    public void verify(Act item) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        Assert.assertEquals((Object)this.patient, (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)this.product, (Object)bean.getTargetRef("product"));
        Assert.assertEquals((Object)this.template, (Object)bean.getTargetRef("template"));
        TestHelper.checkEquals(this.minimumQuantity, bean.getBigDecimal("minQuantity"));
        TestHelper.checkEquals(this.lowQuantity, bean.getBigDecimal("lowQty"));
        TestHelper.checkEquals(this.highQuantity, bean.getBigDecimal("highQty"));
        TestHelper.checkEquals(this.fixedPrice, bean.getBigDecimal("fixedPrice"));
        TestHelper.checkEquals(this.lowUnitPrice, bean.getBigDecimal("lowUnitPrice"));
        TestHelper.checkEquals(this.highUnitPrice, bean.getBigDecimal("highUnitPrice"));
        TestHelper.checkEquals(this.lowDiscount, bean.getBigDecimal("lowDiscount"));
        TestHelper.checkEquals(this.highDiscount, bean.getBigDecimal("highDiscount"));
        Assert.assertEquals((Object)this.print, (Object)bean.getBoolean("print"));
        TestHelper.checkEquals(this.lowTotal, bean.getBigDecimal("lowTotal"));
        TestHelper.checkEquals(this.highTotal, bean.getBigDecimal("highTotal"));
        Participation participation = (Participation)bean.getObject("template", Participation.class);
        if (participation == null) {
            Assert.assertNull((Object)this.group);
        } else {
            IMObjectBean participationBean = this.service.getBean((IMObject)participation);
            Assert.assertEquals((Object)this.group, (Object)participationBean.getValue("group"));
        }
        Assert.assertEquals((Object)this.createdBy, (Object)item.getCreatedBy());
    }

    public void verify(List<Act> items) {
        Act item = FinancialTestHelper.find(items, this.patient, this.product, null);
        if (item == null) {
            Assert.fail((String)("Failed to find estimate item for patient=" + this.patient + ", product=" + this.product));
        }
        this.verify(item);
    }
}

