/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCustomerChargeItemBuilder<P extends TestCustomerChargeBuilder<P, B>, B extends TestCustomerChargeItemBuilder<P, B>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private final P parent;
    private Party patient;
    private User clinician;
    private Product product;
    private Product template;
    private ValueStrategy group = ValueStrategy.unset();
    private ValueStrategy quantity = ValueStrategy.unset();
    private ValueStrategy receivedQuantity = ValueStrategy.unset();
    private ValueStrategy fixedPrice = ValueStrategy.unset();
    private ValueStrategy unitPrice = ValueStrategy.unset();
    private ValueStrategy discount = ValueStrategy.unset();
    private ValueStrategy tax = ValueStrategy.unset();
    private Party stockLocation;

    public TestCustomerChargeItemBuilder(P parent, String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
        this.parent = parent;
    }

    public TestCustomerChargeItemBuilder(P parent, FinancialAct object, ArchetypeService service) {
        super(object, service);
        this.parent = parent;
    }

    public B patient(Party patient) {
        this.patient = patient;
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B clinician(User clinician) {
        this.clinician = clinician;
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B medicationProduct() {
        return this.product(new TestProductFactory(this.getService()).createMedication());
    }

    public B product(Product product) {
        this.product = product;
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B template(Product template) {
        this.template = template;
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B group(int group) {
        this.group = ValueStrategy.value(group);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public B quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B receivedQuantity(int quantity) {
        return this.receivedQuantity(BigDecimal.valueOf(quantity));
    }

    public B receivedQuantity(BigDecimal quantity) {
        this.receivedQuantity = ValueStrategy.value(quantity);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B fixedPrice(int fixedPrice) {
        return this.fixedPrice(BigDecimal.valueOf(fixedPrice));
    }

    public B fixedPrice(BigDecimal fixedPrice) {
        this.fixedPrice = ValueStrategy.value(fixedPrice);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B unitPrice(int unitPrice) {
        return this.unitPrice(BigDecimal.valueOf(unitPrice));
    }

    public B unitPrice(BigDecimal unitPrice) {
        this.unitPrice = ValueStrategy.value(unitPrice);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B discount(int discount) {
        return this.discount(BigDecimal.valueOf(discount));
    }

    public B discount(BigDecimal discount) {
        this.discount = ValueStrategy.value(discount);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B tax(int tax) {
        return this.tax(BigDecimal.valueOf(tax));
    }

    public B tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public B stockLocation(Party stockLocation) {
        this.stockLocation = stockLocation;
        return (B)((TestCustomerChargeItemBuilder)this.getThis());
    }

    public P add() {
        FinancialAct item = (FinancialAct)this.build(false);
        ((TestCustomerChargeBuilder)this.parent).add(item);
        return this.parent;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        if (this.product != null) {
            bean.setTarget("product", (IMObject)this.product);
        }
        if (this.template != null) {
            bean.setTarget("template", (IMObject)this.template);
            Participation participation = (Participation)bean.getObject("template", Participation.class);
            IMObjectBean participationBean = bean.getBean((IMObject)participation);
            this.group.setValue(participationBean, "group");
        }
        this.quantity.setValue(bean, "quantity");
        this.receivedQuantity.setValue(bean, "receivedQuantity");
        this.fixedPrice.setValue(bean, "fixedPrice");
        this.unitPrice.setValue(bean, "unitPrice");
        this.discount.setValue(bean, "discount");
        this.tax.setValue(bean, "tax");
        BigDecimal total = MathRules.calculateTotal((BigDecimal)bean.getBigDecimal("fixedPrice", BigDecimal.ZERO), (BigDecimal)bean.getBigDecimal("unitPrice", BigDecimal.ZERO), (BigDecimal)bean.getBigDecimal("quantity", BigDecimal.ZERO), (BigDecimal)bean.getBigDecimal("discount", BigDecimal.ZERO), (int)2);
        bean.setValue("total", (Object)total);
        if (this.stockLocation != null) {
            bean.setTarget("stockLocation", (IMObject)this.stockLocation);
        }
    }
}

